/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TokenPolicyMetaData {
    public static final String TOKEN_POLICY = "token.policy";
    private AuthenticationTokenPolicy tokenPolicy = null;

    public TokenPolicyMetaData(Map runtimeProperties) {
        this.tokenPolicy = (AuthenticationTokenPolicy)runtimeProperties.get(TOKEN_POLICY);
    }

    public String getIssuer() {
        if (this.tokenPolicy == null) {
            return null;
        }
        KeyBindingBase kb = (KeyBindingBase)this.tokenPolicy.getFeatureBinding();
        return kb.getIssuer();
    }

    public Element getClaims() throws XWSSecurityException {
        if (this.tokenPolicy == null) {
            return null;
        }
        KeyBindingBase kb = (KeyBindingBase)this.tokenPolicy.getFeatureBinding();
        Element claimsElement = null;
        byte[] claimBytes = kb.getClaims();
        if (claimBytes != null) {
            try {
                DocumentBuilderFactory dbf = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(claimBytes));
                claimsElement = (Element)doc.getElementsByTagNameNS("*", "Claims").item(0);
            }
            catch (SAXException ex) {
                Logger.getLogger(TokenPolicyMetaData.class.getName()).log(Level.SEVERE, null, ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (IOException ex) {
                Logger.getLogger(TokenPolicyMetaData.class.getName()).log(Level.SEVERE, null, ex);
                throw new XWSSecurityException((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(TokenPolicyMetaData.class.getName()).log(Level.SEVERE, null, ex);
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        return claimsElement;
    }
}

