/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.oracle.webservices.oracle_internal_api.rm.InboundAccepted;
import com.oracle.webservices.oracle_internal_api.rm.InboundAcceptedAcceptFailed;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionPropertySet;
import java.util.logging.Level;

public class InboundAcceptedImpl
extends InboundAccepted {
    private static final Logger LOGGER = Logger.getLogger(InboundAcceptedImpl.class);
    private final JaxwsApplicationMessage request;
    private final RuntimeContext rc;
    private Boolean accepted;

    public InboundAcceptedImpl(JaxwsApplicationMessage request, RuntimeContext rc) {
        this.request = request;
        this.rc = rc;
    }

    public void setAccepted(Boolean accept) throws InboundAcceptedAcceptFailed {
        boolean txOwned;
        if (accept == null) {
            throw new IllegalArgumentException("Found supplied accept Boolean null.");
        }
        this.accepted = accept;
        TransactionPropertySet ps = (TransactionPropertySet)this.request.getPacket().getSatellite(TransactionPropertySet.class);
        boolean bl = txOwned = ps != null && ps.isTransactionOwned();
        if (accept.booleanValue()) {
            this.rc.destinationMessageHandler.acknowledgeApplicationLayerDelivery(this.request);
            if (txOwned) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Transaction status before commit: " + this.rc.transactionHandler.getStatusAsString());
                }
                try {
                    this.rc.transactionHandler.commit();
                }
                catch (Throwable t) {
                    this.accepted = null;
                    throw new InboundAcceptedAcceptFailed("Not able to commit the TX.", t);
                }
            }
        } else if (txOwned) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Transaction status before rollback: " + this.rc.transactionHandler.getStatusAsString());
            }
            this.rc.transactionHandler.rollback();
        } else if (this.rc.transactionHandler.userTransactionAvailable() && this.rc.transactionHandler.isActive()) {
            this.rc.transactionHandler.setRollbackOnly();
        }
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public String getRMSequenceId() {
        return (String)this.request.getPacket().invocationProperties.get("com.sun.xml.ws.sequence");
    }

    public long getRMMessageNumber() {
        return (Long)this.request.getPacket().invocationProperties.get("com.sun.xml.ws.messagenumber");
    }
}

