/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.attachment;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.ws.util.ByteArrayDataSource;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class AttachmentImpl
implements Attachment {
    private final String contentId;
    private byte[] data;
    private final String mimeType;

    public AttachmentImpl(@NotNull String contentId, byte[] data, String mimeType) {
        this.contentId = contentId;
        this.data = data;
        this.mimeType = mimeType;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public byte[] asByteArray() {
        return this.data;
    }

    public DataHandler asDataHandler() {
        return new DataSourceStreamingDataHandler((DataSource)new ByteArrayDataSource(this.data, this.getContentType()));
    }

    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.asByteArray());
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        AttachmentPart part = saaj.createAttachmentPart();
        part.setDataHandler(this.asDataHandler());
        part.setContentId(this.contentId);
        saaj.addAttachmentPart(part);
    }
}

