/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.processor.SecurityTokenProcessor;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class DerivedKeyToken
implements SecurityHeaderElement,
NamespaceContextInfo,
SecurityElementWriter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.token", "com.sun.xml.wss.logging.impl.opt.token.LogStrings");
    private static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference".intern();
    private static final String LENGTH = "Length".intern();
    private static final String OFFSET = "Offset".intern();
    private static final String GENERATION = "Generation".intern();
    private static final String NONCE = "Nonce".intern();
    private static final String LABEL = "Label".intern();
    private static final int SECURITY_TOKEN_REFERENCE_ELEMENT = 3;
    private static final int LENGTH_ELEMENT = 4;
    private static final int OFFSET_ELEMENT = 5;
    private static final int GENERATION_ELEMENT = 6;
    private static final int NONCE_ELEMENT = 7;
    private static final int LABEL_ELEMENT = 8;
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private long offset = 0L;
    private long length = 32L;
    private String label = null;
    private String nonce = null;
    private byte[] decodedNonce = null;
    private long generation = -1L;
    private HashMap<String, String> nsDecls;
    private Key originalKey = null;
    private MutableXMLStreamBuffer buffer = null;
    private JAXBFilterProcessingContext pc = null;
    private WSSPolicy inferredKB = null;

    public DerivedKeyToken(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap nsDecls) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.nsDecls = nsDecls;
        this.buffer = new MutableXMLStreamBuffer();
        this.process(reader);
    }

    public Key getKey() throws XWSSecurityException {
        String dataEncAlgo = null;
        if (this.originalKey == null) {
            SecurityTokenProcessor stp = new SecurityTokenProcessor(this.pc, null);
            try {
                StreamReaderBufferProcessor breader = this.buffer.readAsXMLStreamReader();
                if (breader.getEventType() != 1) {
                    StreamUtil.moveToNextStartOREndElement((XMLStreamReader)breader);
                }
                this.pc.getSecurityContext().setInferredKB(null);
                this.originalKey = stp.resolveReference((XMLStreamReader)breader);
                this.inferredKB = (WSSPolicy)this.pc.getSecurityContext().getInferredKB();
                this.pc.getSecurityContext().setInferredKB(null);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1855_XML_STREAM_READER_ERROR(), ex);
            }
        }
        if (this.pc.getAlgorithmSuite() == null) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1818_ALGORITHM_NOTSET_DERIVEDKEY());
            throw new XWSSecurityException(LogStringsMessages.WSS_1818_ALGORITHM_NOTSET_DERIVEDKEY());
        }
        dataEncAlgo = this.pc.getAlgorithmSuite().getEncryptionAlgorithm();
        try {
            byte[] secret = this.originalKey.getEncoded();
            DerivedKeyTokenImpl dkt = new DerivedKeyTokenImpl(this.offset, this.length, secret, this.decodedNonce, this.label);
            String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo);
            return dkt.generateSymmetricKey(jceAlgo);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1819_ERROR_SYMMKEY_DERIVEDKEY());
            throw new XWSSecurityException(LogStringsMessages.WSS_1819_ERROR_SYMMKEY_DERIVEDKEY(), ex);
        }
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) {
        throw new UnsupportedOperationException();
    }

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        boolean offsetSpecified = false;
        boolean genSpecified = false;
        boolean invalidToken = false;
        if (StreamUtil.moveToNextElement(reader)) {
            int refElement = this.getEventType(reader);
            while (reader.getEventType() != 8) {
                switch (refElement) {
                    case 3: {
                        this.buffer.createFromXMLStreamReader(reader);
                        break;
                    }
                    case 4: {
                        this.length = Integer.parseInt(reader.getElementText());
                        break;
                    }
                    case 5: {
                        this.offset = Integer.parseInt(reader.getElementText());
                        offsetSpecified = true;
                        break;
                    }
                    case 6: {
                        this.generation = Integer.parseInt(reader.getElementText());
                        genSpecified = true;
                        break;
                    }
                    case 8: {
                        this.label = reader.getElementText();
                        break;
                    }
                    case 7: {
                        if (reader instanceof XMLStreamReaderEx) {
                            reader.next();
                            StringBuilder sb = null;
                            if (reader.getEventType() == 4 && reader.getEventType() != 2) {
                                CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                                if (charSeq instanceof Base64Data) {
                                    Base64Data bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                                    this.decodedNonce = bd.getExact();
                                } else {
                                    if (sb == null) {
                                        sb = new StringBuilder();
                                    }
                                    for (int i = 0; i < charSeq.length(); ++i) {
                                        sb.append(charSeq.charAt(i));
                                    }
                                }
                                reader.next();
                            }
                            if (sb == null) break;
                            this.nonce = sb.toString();
                            try {
                                this.decodedNonce = Base64.decode(this.nonce);
                                break;
                            }
                            catch (Base64DecodingException dec) {
                                logger.log(Level.SEVERE, LogStringsMessages.WSS_1820_ERROR_NONCE_DERIVEDKEY(this.id));
                                throw new XWSSecurityException(LogStringsMessages.WSS_1820_ERROR_NONCE_DERIVEDKEY(this.id), dec);
                            }
                        }
                        this.nonce = reader.getElementText();
                        try {
                            this.decodedNonce = Base64.decode(this.nonce);
                            break;
                        }
                        catch (Base64DecodingException ex) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1820_ERROR_NONCE_DERIVEDKEY(this.id));
                            throw new XWSSecurityException(LogStringsMessages.WSS_1820_ERROR_NONCE_DERIVEDKEY(this.id), ex);
                        }
                    }
                    default: {
                        throw new XWSSecurityException("Element name " + reader.getName() + " is not recognized under DerivedKeyToken");
                    }
                }
                if (!StreamUtil.isStartElement(reader) && StreamUtil.moveToNextStartOREndElement(reader) && StreamUtil._break(reader, "DerivedKeyToken", "http://schemas.xmlsoap.org/ws/2005/02/sc")) {
                    StreamUtil.moveToNextStartOREndElement(reader);
                    break;
                }
                if (reader.getEventType() != 1) {
                    StreamUtil.moveToNextStartOREndElement(reader);
                    boolean isBreak = false;
                    while (reader.getEventType() == 2) {
                        if (StreamUtil._break(reader, "DerivedKeyToken", "http://schemas.xmlsoap.org/ws/2005/02/sc")) {
                            isBreak = true;
                            StreamUtil.moveToNextStartOREndElement(reader);
                            break;
                        }
                        StreamUtil.moveToNextStartOREndElement(reader);
                    }
                    if (isBreak) break;
                }
                refElement = this.getEventType(reader);
            }
        }
        if (offsetSpecified && genSpecified) {
            invalidToken = true;
        }
        if (invalidToken) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1821_INVALID_DKT_TOKEN());
            throw new XWSSecurityException(LogStringsMessages.WSS_1821_INVALID_DKT_TOKEN());
        }
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == SECURITY_TOKEN_REFERENCE) {
                return 3;
            }
            if (reader.getLocalName() == LENGTH) {
                return 4;
            }
            if (reader.getLocalName() == OFFSET) {
                return 5;
            }
            if (reader.getLocalName() == GENERATION) {
                return 6;
            }
            if (reader.getLocalName() == NONCE) {
                return 7;
            }
            if (reader.getLocalName() == LABEL) {
                return 8;
            }
        }
        return -1;
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) {
        throw new UnsupportedOperationException();
    }

    public WSSPolicy getInferredKB() {
        return this.inferredKB;
    }
}

