/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.runtime;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.Xid;

class TransactionIdHelperImpl
extends TransactionIdHelper {
    private static final int FFID = 65309;
    private Map<String, Xid> tids2xids = new HashMap<String, Xid>();
    private Map<Xid, String> xids2tids = new HashMap<Xid, String>();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public String xid2wsatid(Xid xid) {
        return TransactionIdHelperImpl.xidToString(xid, true);
    }

    static String xidToString(Xid xid, boolean includeBranchQualifier) {
        String bqual;
        if (xid == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(Integer.toHexString(xid.getFormatId()).toUpperCase(Locale.ENGLISH)).append("-").append(TransactionIdHelperImpl.byteArrayToString(xid.getGlobalTransactionId()));
        if (includeBranchQualifier && !(bqual = TransactionIdHelperImpl.byteArrayToString(xid.getBranchQualifier())).equals("")) {
            sb.append("-").append(TransactionIdHelperImpl.byteArrayToString(xid.getBranchQualifier()));
        }
        return sb.toString();
    }

    private static String byteArrayToString(byte[] barray) {
        if (barray == null) {
            return "";
        }
        char[] res = new char[barray.length * 2];
        int j = 0;
        for (int i = 0; i < barray.length; ++i) {
            res[j++] = DIGITS[(barray[i] & 0xF0) >>> 4];
            res[j++] = DIGITS[barray[i] & 0xF];
        }
        return new String(res);
    }

    @Override
    public Xid wsatid2xid(String wsatid) {
        return TransactionIdHelperImpl.create(wsatid);
    }

    public static XidImpl create(String xid) {
        StringTokenizer tok = new StringTokenizer(xid, "-");
        if (tok.countTokens() < 2) {
            return null;
        }
        String formatIdString = tok.nextToken();
        String gtridString = tok.nextToken();
        String bqualString = null;
        if (tok.hasMoreElements()) {
            bqualString = tok.nextToken();
        }
        return new XidImpl(Integer.parseInt(formatIdString, 16), TransactionIdHelperImpl.stringToByteArray(gtridString), bqualString != null ? TransactionIdHelperImpl.stringToByteArray(bqualString) : new byte[]{});
    }

    private static byte[] stringToByteArray(String str) {
        if (str == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[str.length() / 2];
        int i = 0;
        int j = 0;
        while (i < str.length()) {
            bytes[j] = (byte)(Byte.parseByte(str.substring(i++, i), 16) << 4 | Byte.parseByte(str.substring(i, i + 1), 16));
            ++i;
            ++j;
        }
        return bytes;
    }

    @Override
    public synchronized Xid getOrCreateXid(byte[] tid) {
        Xid xid = this.getXid(tid);
        if (xid != null) {
            return xid;
        }
        byte[] gtrid = WSATHelper.assignUUID().getBytes();
        xid = new XidImpl(65309, gtrid, null);
        String stid = new String(tid);
        this.tids2xids.put(stid, xid);
        this.xids2tids.put(xid, stid);
        return xid;
    }

    @Override
    public synchronized byte[] getTid(Xid xid) {
        String stid = this.xids2tids.get(xid);
        if (stid == null) {
            return null;
        }
        return stid.getBytes();
    }

    @Override
    public synchronized Xid getXid(byte[] tid) {
        return this.tids2xids.get(new String(tid));
    }

    @Override
    public synchronized Xid remove(byte[] tid) {
        if (this.getXid(tid) == null) {
            return null;
        }
        Xid xid = this.tids2xids.remove(tid);
        this.xids2tids.remove(xid);
        return xid;
    }

    @Override
    public synchronized byte[] remove(Xid xid) {
        if (this.getTid(xid) == null) {
            return null;
        }
        String stid = this.xids2tids.remove(xid);
        this.tids2xids.remove(stid);
        return stid.getBytes();
    }

    public String toString() {
        return this.tids2xids.toString();
    }
}

