/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATConstants;
import com.sun.xml.ws.tx.at.WSATSynchronization;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.ParticipantIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.common.client.CoordinatorProxyBuilder;
import com.sun.xml.ws.tx.at.common.client.ParticipantProxyBuilder;
import com.sun.xml.ws.tx.at.internal.BranchXidImpl;
import com.sun.xml.ws.tx.at.internal.TransactionServicesImpl;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import com.sun.xml.ws.tx.dev.WSATRuntimeConfig;
import jakarta.transaction.Transaction;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.MessageContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class WSATHelper<T> {
    private static final Logger LOGGER = Logger.getLogger(WSATHelper.class);
    public static final WSATHelper V10 = new WSATHelper().WSATVersion(WSATVersion.v10);
    public static final WSATHelper V11 = new WSATHelper(){

        @Override
        public String getRegistrationCoordinatorAddress() {
            return 1.getHostAndPort() + "/__wstx-services/RegistrationPortTypeRPC11";
        }

        @Override
        public String getCoordinatorAddress() {
            return 1.getHostAndPort() + "/__wstx-services/CoordinatorPortType11";
        }

        @Override
        public String getParticipantAddress() {
            return 1.getHostAndPort() + "/__wstx-services/ParticipantPortType11";
        }

        @Override
        public String getRegistrationRequesterAddress() {
            return 1.getHostAndPort() + "/__wstx-services/RegistrationRequesterPortType11";
        }
    }.WSATVersion(WSATVersion.v11);
    private Map<WSATXAResource, ParticipantIF<T>> m_durableParticipantPortMap = new HashMap<WSATXAResource, ParticipantIF<T>>();
    private final Object m_durableParticipantPortMapLock = new Object();
    private Map<Xid, WSATXAResource> m_durableParticipantXAResourceMap = new HashMap<Xid, WSATXAResource>();
    private final Object m_durableParticipantXAResourceMapLock = new Object();
    private Map<Xid, ParticipantIF<T>> m_volatileParticipantPortMap = new HashMap<Xid, ParticipantIF<T>>();
    private final Object m_volatileParticipantPortMapLock = new Object();
    private Map<Xid, WSATSynchronization> m_volatileParticipantSynchronizationMap = new HashMap<Xid, WSATSynchronization>();
    private final Object m_volatileParticipantSynchronizationMapLock = new Object();
    private final int m_waitForReplyTimeout = new Integer(System.getProperty("com.sun.xml.ws.tx.at.reply.timeout", "120"));
    private final boolean m_isUseLocalServerAddress = Boolean.valueOf(System.getProperty("com.sun.xml.ws.tx.at.use.local.server.address", "false"));
    protected WSATVersion<T> builderFactory;
    private Map<Xid, Transaction> m_xidToTransactionMap = new HashMap<Xid, Transaction>();

    WSATHelper WSATVersion(WSATVersion builderFactory) {
        this.builderFactory = builderFactory;
        return this;
    }

    protected WSATHelper() {
    }

    public static WSATHelper getInstance() {
        return V10;
    }

    public static WSATHelper getInstance(Transactional.Version version) {
        if (version == Transactional.Version.WSAT10 || version == Transactional.Version.DEFAULT) {
            return V10;
        }
        if (version == Transactional.Version.WSAT12 || version == Transactional.Version.WSAT11) {
            return V11;
        }
        throw new WebServiceException("not supported WSAT version");
    }

    public static TransactionServices getTransactionServices() {
        return TransactionServicesImpl.getInstance();
    }

    public int getWaitForReplyTimeout() {
        return this.m_waitForReplyTimeout * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDurableParticipantStatus(Xid xid, String status) {
        WSATXAResource wsatXAResourceLock;
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            wsatXAResourceLock = this.getDurableParticipantXAResourceMap().get(new BranchXidImpl(xid));
        }
        if (wsatXAResourceLock == null) {
            return false;
        }
        object = wsatXAResourceLock;
        synchronized (object) {
            wsatXAResourceLock.setStatus(status);
            wsatXAResourceLock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setVolatileParticipantStatus(Xid xid, String status) {
        WSATSynchronization wsatSynchronization;
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            wsatSynchronization = this.m_volatileParticipantSynchronizationMap.get(xid);
        }
        if (wsatSynchronization == null) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4581_XID_NOT_IN_DURABLE_RESOURCE_MAP(xid, status));
            }
            return false;
        }
        object = wsatSynchronization;
        synchronized (object) {
            wsatSynchronization.setStatus(status);
            wsatSynchronization.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDurableParticipant(WSATXAResource wsatXAResource) {
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            if (this.getDurableParticipantPortMap().containsKey(wsatXAResource)) {
                this.m_durableParticipantPortMap.remove(wsatXAResource);
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4583_DURABLE_PORT_REMOVED(wsatXAResource));
                }
            }
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            if (this.getDurableParticipantXAResourceMap().containsKey(wsatXAResource.getXid())) {
                this.getDurableParticipantXAResourceMap().remove(wsatXAResource.getXid());
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4584_DURABLE_XARESOURCE_REMOVED(wsatXAResource));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeVolatileParticipant(Xid xid) {
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantPortMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantPortMap.remove(new BranchXidImpl(xid));
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4585_VOLATILE_PORT_REMOVED(new BranchXidImpl(xid)));
                }
            }
        }
        object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            if (this.m_volatileParticipantSynchronizationMap.containsKey(new BranchXidImpl(xid))) {
                this.m_volatileParticipantSynchronizationMap.remove(new BranchXidImpl(xid));
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4586_VOLATILE_SYNCHRONIZATION_REMOVED(xid));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4587_ABOUT_TO_SEND_PREPARE(xid, Thread.currentThread()));
        }
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            this.putInDurableParticipantXAResourceMap(wsatXAResource, xid);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4589_DURABLE_PARTICIPANT_XARESOURCE_PLACED_IN_CACHE_FROM_PREPARE(xid));
        }
        ParticipantIF<T> port = this.getDurableParticipantPort(epr, xid, wsatXAResource);
        T notification = this.builderFactory.newNotificationBuilder().build();
        port.prepare(notification);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4588_PREPARE_SENT(xid, Thread.currentThread()));
        }
    }

    private void putInDurableParticipantXAResourceMap(WSATXAResource wsatXAResource, Xid xid) {
        byte[] xidBqual = xid.getBranchQualifier();
        byte[] bqual = new byte[xidBqual.length - 1];
        System.arraycopy(xidBqual, 0, bqual, 0, bqual.length);
        XidImpl xidImpl = new XidImpl(xid.getFormatId(), xid.getGlobalTransactionId(), bqual);
        BranchXidImpl branchXid = new BranchXidImpl(xidImpl);
        this.getDurableParticipantXAResourceMap().put(branchXid, wsatXAResource);
    }

    public void commit(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4590_ABOUT_TO_SEND_COMMIT(xid, Thread.currentThread()));
        }
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(epr, xid, wsatXAResource).commit(notification);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4591_COMMIT_SENT(xid, Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4592_ABOUT_TO_SEND_ROLLBACK(xid, Thread.currentThread()));
        }
        Object object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            this.putInDurableParticipantXAResourceMap(wsatXAResource, xid);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4594_ROLLBACK_PARTICIPANT_XARESOURCE_PLACED_IN_CACHE(xid));
        }
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getDurableParticipantPort(epr, xid, wsatXAResource).rollback(notification);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4593_ROLLBACK_SENT(xid, Thread.currentThread()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion(EndpointReference epr, Xid xid, WSATSynchronization wsatSynchronization) throws SOAPException {
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4595_ABOUT_TO_SEND_PREPARE_VOLATILE(xid, Thread.currentThread()));
        }
        T notification = this.builderFactory.newNotificationBuilder().build();
        this.getVolatileParticipantPort(epr, xid).prepare(notification);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4596_PREPARE_VOLATILE_SENT(xid, Thread.currentThread()));
        }
        Object object = this.m_volatileParticipantSynchronizationMapLock;
        synchronized (object) {
            this.m_volatileParticipantSynchronizationMap.put(new BranchXidImpl(xid), wsatSynchronization);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4597_PREPARE_PARTICIPANT_SYNCHRONIZATION_PLACED_IN_CACHE(xid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getVolatileParticipantPort(EndpointReference epr, Xid xid) throws SOAPException {
        ParticipantIF<T> participantPort;
        Object object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            participantPort = this.m_volatileParticipantPortMap.get(new BranchXidImpl(xid));
        }
        if (participantPort != null) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4598_VOLATILE_PARTICIPANT_RETRIEVED_FROM_CACHE(xid));
            }
            return participantPort;
        }
        participantPort = this.getParticipantPort(epr, xid, null);
        object = this.m_volatileParticipantPortMapLock;
        synchronized (object) {
            this.m_volatileParticipantPortMap.put(new BranchXidImpl(xid), participantPort);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4599_VOLATILE_PARTICIPANT_PORT_PLACED_IN_CACHE(xid));
        }
        return participantPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParticipantIF<T> getDurableParticipantPort(EndpointReference epr, Xid xid, WSATXAResource wsatXAResource) throws XAException {
        ParticipantIF<T> participantPort;
        Object object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            participantPort = this.getDurableParticipantPortMap().get(wsatXAResource);
        }
        if (participantPort != null) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4600_DURABLE_PARTICIPANT_PORT_RETREIVED_FROM_CACHE(xid));
            }
            return participantPort;
        }
        try {
            participantPort = this.getParticipantPort(epr, xid, new String(wsatXAResource.getXid().getBranchQualifier()));
        }
        catch (SOAPException e) {
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4601_CANNOT_CREATE_DURABLE_PARTICIPANT_PORT(xid));
            }
            e.printStackTrace();
            XAException xaException = new XAException("Unable to create durable participant port:" + (Object)((Object)e));
            xaException.initCause(e);
            xaException.errorCode = -7;
            throw xaException;
        }
        object = this.m_durableParticipantXAResourceMapLock;
        synchronized (object) {
            this.putInDurableParticipantXAResourceMap(wsatXAResource, xid);
        }
        object = this.m_durableParticipantPortMapLock;
        synchronized (object) {
            this.getDurableParticipantPortMap().put(wsatXAResource, participantPort);
        }
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4602_DURABLE_PARTICIPANT_PORT_PLACED_IN_CACHE(xid));
        }
        return participantPort;
    }

    public ParticipantIF<T> getParticipantPort(EndpointReference epr, Xid xid, String bqual) throws SOAPException {
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        ParticipantProxyBuilder<T> proxyBuilder = this.builderFactory.newParticipantProxyBuilder();
        ParticipantIF participantProxyIF = ((ParticipantProxyBuilder)((ParticipantProxyBuilder)proxyBuilder.to(epr)).txIdForReference(txId, bqual)).build();
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4603_SUCCESSFULLY_CREATED_PARTICIPANT_PORT(participantProxyIF, xid));
        }
        return participantProxyIF;
    }

    public CoordinatorIF<T> getCoordinatorPort(EndpointReference epr, Xid xid) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + epr);
        }
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        CoordinatorProxyBuilder<T> proxyBuilder = this.builderFactory.newCoordinatorProxyBuilder();
        CoordinatorIF coordinatorProxy = ((CoordinatorProxyBuilder)((CoordinatorProxyBuilder)proxyBuilder.to(epr)).txIdForReference(txId, "")).build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getCoordinatorPort xid:" + xid + " epr:" + epr + " coordinatorProxy:" + coordinatorProxy);
        }
        return coordinatorProxy;
    }

    public String getRoutingAddress() {
        return "none";
    }

    static String getHostAndPort() {
        return WSATRuntimeConfig.getInstance().getHostAndPort();
    }

    public String getRegistrationCoordinatorAddress() {
        return WSATHelper.getHostAndPort() + "/__wstx-services/RegistrationPortTypeRPC";
    }

    public String getCoordinatorAddress() {
        return WSATHelper.getHostAndPort() + "/__wstx-services/CoordinatorPortType";
    }

    public String getParticipantAddress() {
        return WSATHelper.getHostAndPort() + "/__wstx-services/ParticipantPortType";
    }

    public String getRegistrationRequesterAddress() {
        return WSATHelper.getHostAndPort() + "/__wstx-services/RegistrationRequesterPortType";
    }

    public Xid getXidFromWebServiceContextHeaderList(WebServiceContext context) {
        String txId = this.getWSATTidFromWebServiceContextHeaderList(context);
        return TransactionIdHelper.getInstance().wsatid2xid(txId);
    }

    public String getWSATTidFromWebServiceContextHeaderList(WebServiceContext context) {
        MessageContext messageContext = context.getMessageContext();
        MessageHeaders headerList = (MessageHeaders)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator headers = headerList.getHeaders(WSATConstants.TXID_QNAME, false);
        if (!headers.hasNext()) {
            throw new WebServiceException("txid does not exist in header");
        }
        String txId = ((Header)headers.next()).getStringContent();
        return txId;
    }

    public String getBQualFromWebServiceContextHeaderList(WebServiceContext context) {
        MessageContext messageContext = context.getMessageContext();
        MessageHeaders headerList = (MessageHeaders)messageContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Iterator headers = headerList.getHeaders(WSATConstants.BRANCHQUAL_QNAME, false);
        if (!headers.hasNext()) {
            throw new WebServiceException("branchqual does not exist in header");
        }
        String bqual = ((Header)headers.next()).getStringContent();
        if (bqual != null) {
            bqual = bqual.replaceAll("&#044;", ",");
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("WSATHelper.getBQualFromWebServiceContextHeaderList returning bqual:" + bqual + " on thread:" + Thread.currentThread());
        }
        return bqual;
    }

    public static boolean isDebugEnabled() {
        return true;
    }

    public Map<WSATXAResource, ParticipantIF<T>> getDurableParticipantPortMap() {
        return this.m_durableParticipantPortMap;
    }

    Map<Xid, WSATXAResource> getDurableParticipantXAResourceMap() {
        return this.m_durableParticipantXAResourceMap;
    }

    public Map<Xid, WSATSynchronization> getVolatileParticipantSynchronizationMap() {
        return this.m_volatileParticipantSynchronizationMap;
    }

    public Map<Xid, ParticipantIF<T>> getVolatileParticipantPortMap() {
        return this.m_volatileParticipantPortMap;
    }

    public void putToXidToTransactionMap(Xid xid, Transaction transaction) {
        this.m_xidToTransactionMap.put(new XidImpl(xid), transaction);
    }

    public Transaction getFromXidToTransactionMap(Xid xid) {
        Transaction transaction = this.m_xidToTransactionMap.get(xid);
        return transaction;
    }

    public void removeFromXidToTransactionMap(Xid xid) {
        this.m_xidToTransactionMap.remove(xid);
    }

    private void debug(String msg) {
        LOGGER.log(Level.INFO, msg);
    }

    public static String assignUUID() {
        return UUID.randomUUID().toString();
    }
}

