/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.IssuedTokens;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.KeyIdentifier;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseCollectionType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.impl.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.elements.IssuedTokensImpl;
import com.sun.xml.ws.security.trust.impl.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenResponseCollectionImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestSecurityTokenResponseImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedAttachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedProofTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedSecurityTokenImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedTokenCancelledImpl;
import com.sun.xml.ws.security.trust.impl.elements.RequestedUnattachedReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.StatusImpl;
import com.sun.xml.ws.security.trust.impl.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.DirectReferenceImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.KeyIdentifierImpl;
import com.sun.xml.ws.security.trust.impl.elements.str.SecurityTokenReferenceImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.TrustNamespacePrefixMapper;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.util.JAXBSource;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSTrustElementFactoryImpl
extends WSTrustElementFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private static final String RST = "RST";
    private static final String RSTRCollection = "RSTRCollection";

    public RequestSecurityToken createRSTForIssue(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        if (tokenType == null && scopes == null) {
            log.log(Level.WARNING, LogStringsMessages.WST_1003_TOKENTYPE_APPLIESTO_NULL());
        }
        return new RequestSecurityTokenImpl(tokenType, requestType, context, scopes, claims, entropy, lifetime, null);
    }

    public RequestSecurityTokenResponse createRSTRForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, scopes, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(URI tokenType, URI context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseCollectionImpl rstrCollection = new RequestSecurityTokenResponseCollectionImpl(tokenType, context, token, scopes, attached, unattached, proofToken, entropy, lifetime);
        return rstrCollection;
    }

    public RequestSecurityTokenResponse createRSTRForRenew(URI tokenType, URI context, RequestedSecurityToken token, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedRef, RequestedProofToken proofToken, Entropy entropy, Lifetime lifetime) throws WSTrustException {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(tokenType, context, token, null, attachedReference, unattachedRef, proofToken, entropy, lifetime, null);
        return rstr;
    }

    public IssuedTokens createIssuedTokens(RequestSecurityTokenResponseCollection issuedTokens) {
        return new IssuedTokensImpl(issuedTokens);
    }

    public OnBehalfOf createOnBehalfOf(Token oboToken) {
        return new OnBehalfOfImpl(oboToken);
    }

    public ValidateTarget createValidateTarget(Token token) {
        throw new UnsupportedOperationException("Unsupported operation: ValidateTarget");
    }

    public ActAs createActAs(Token token) {
        throw new UnsupportedOperationException("Unsupported operation: createActAs");
    }

    public Entropy createEntropy(BinarySecret secret) {
        return new EntropyImpl(secret);
    }

    public Entropy createEntropy(EncryptedKey key) {
        return new EntropyImpl(key);
    }

    public BinarySecret createBinarySecret(byte[] rawValue, String type) {
        return new BinarySecretImpl(rawValue, type);
    }

    public BinarySecret createBinarySecret(Element elem) throws WSTrustException {
        return new BinarySecretImpl(BinarySecretImpl.fromElement(elem));
    }

    public Lifetime createLifetime(AttributedDateTime created, AttributedDateTime expires) {
        return new LifetimeImpl(created, expires);
    }

    public Claims createClaims(Element elem) throws WSTrustException {
        return new ClaimsImpl(ClaimsImpl.fromElement(elem));
    }

    public Claims createClaims(Claims claims) throws WSTrustException {
        ClaimsImpl newClaims = new ClaimsImpl();
        if (claims != null) {
            newClaims.setDialect(claims.getDialect());
            newClaims.getAny().addAll(claims.getAny());
            newClaims.getOtherAttributes().putAll(claims.getOtherAttributes());
        }
        return newClaims;
    }

    public Claims createClaims() throws WSTrustException {
        return new ClaimsImpl();
    }

    public Status createStatus(String code, String reason) {
        return new StatusImpl(code, reason);
    }

    public RequestedSecurityToken createRequestedSecurityToken(Token token) {
        return new RequestedSecurityTokenImpl(token);
    }

    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityTokenImpl();
    }

    public DirectReference createDirectReference(String valueType, String uri) {
        return new DirectReferenceImpl(valueType, uri);
    }

    public DirectReference createDirectReference(String valueType, String uri, String instanceId) {
        return new DirectReferenceImpl(valueType, uri, instanceId);
    }

    public KeyIdentifier createKeyIdentifier(String valueType, String encodingType) {
        return new KeyIdentifierImpl(valueType, encodingType);
    }

    public SecurityTokenReference createSecurityTokenReference(Reference ref) {
        return new SecurityTokenReferenceImpl(ref);
    }

    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference str) {
        return new RequestedAttachedReferenceImpl(str);
    }

    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference str) {
        return new RequestedUnattachedReferenceImpl(str);
    }

    public RequestedProofToken createRequestedProofToken() {
        return new RequestedProofTokenImpl();
    }

    public SecondaryParameters createSecondaryParameters() {
        throw new UnsupportedOperationException("Unsupported operation: createSecondaryParameters");
    }

    public UseKey createUseKey(Token token, String sig) {
        UseKeyImpl useKey = new UseKeyImpl(token);
        if (sig != null) {
            useKey.setSignatureID(URI.create(sig));
        }
        return useKey;
    }

    public RequestSecurityToken createRSTForRenew(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        return new RequestSecurityTokenImpl(tokenType, requestType, context, target, apd, renewingInfo);
    }

    public RenewTarget createRenewTarget(SecurityTokenReference str) {
        return new RenewTargetImpl(str);
    }

    public CancelTarget createCancelTarget(SecurityTokenReference str) {
        return new CancelTargetImpl(str);
    }

    public RequestSecurityToken createRSTForCancel(URI requestType, CancelTarget target) {
        return new RequestSecurityTokenImpl(null, requestType, target);
    }

    public RequestSecurityTokenResponse createRSTRForCancel() {
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl();
        rstr.setRequestedTokenCancelled(new RequestedTokenCancelledImpl());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1008_CREATED_RSTR_CANCEL(rstr.toString()));
        }
        return rstr;
    }

    public RequestSecurityToken createRSTForValidate(URI tokenType, URI requestType) {
        return new RequestSecurityTokenImpl(tokenType, requestType);
    }

    public RequestSecurityTokenResponse createRSTRForValidate(URI tokenType, RequestedSecurityToken token, Status status) {
        return new RequestSecurityTokenResponseImpl(tokenType, null, token, null, null, null, null, null, null, status);
    }

    public RequestSecurityToken createRST() {
        return new RequestSecurityTokenImpl();
    }

    public RequestSecurityTokenResponse createRSTR() {
        return new RequestSecurityTokenResponseImpl();
    }

    public RequestSecurityTokenResponseCollection createRSTRC(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollectionImpl rstrc = new RequestSecurityTokenResponseCollectionImpl();
        rstrc.getRequestSecurityTokenResponses().addAll(rstrs);
        return rstrc;
    }

    public RequestSecurityToken createRSTFrom(Source src) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstType = unmarshaller.unmarshal(src, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0006_FAIL_RST_SOURCE(src.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0006_FAIL_RST_SOURCE(src.toString()), ex);
        }
    }

    public RequestSecurityToken createRSTFrom(Element elem) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstType = unmarshaller.unmarshal((Node)elem, RequestSecurityTokenType.class);
            RequestSecurityTokenType type = (RequestSecurityTokenType)rstType.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0007_FAIL_RST_ELEM(elem.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0007_FAIL_RST_ELEM(elem.toString()), ex);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(Source src) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstType = unmarshaller.unmarshal(src, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(src.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(src.toString()), ex);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(Element elem) {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstType = unmarshaller.unmarshal((Node)elem, RequestSecurityTokenResponseType.class);
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)rstType.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(elem.toString()), ex);
            throw new RuntimeException(LogStringsMessages.WST_0008_FAIL_RSTR_SOURCE(elem.toString()), ex);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Source src) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal(src, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(Element elem) {
        try {
            Unmarshaller u = WSTrustElementFactoryImpl.getContext().createUnmarshaller();
            JAXBElement rstrcType = u.unmarshal((Node)elem, RequestSecurityTokenResponseCollectionType.class);
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)rstrcType.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public RequestSecurityToken createRSTFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenType type = (RequestSecurityTokenType)elem.getValue();
            return new RequestSecurityTokenImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RST), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RST), e);
        }
    }

    public RequestSecurityTokenResponse createRSTRFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseType type = (RequestSecurityTokenResponseType)elem.getValue();
            return new RequestSecurityTokenResponseImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0009_FAIL_RSTR_ELEM(elem.toString()), e);
            throw new RuntimeException(LogStringsMessages.WST_0009_FAIL_RSTR_ELEM(elem.toString()), e);
        }
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionFrom(JAXBElement elem) {
        try {
            RequestSecurityTokenResponseCollectionType type = (RequestSecurityTokenResponseCollectionType)elem.getValue();
            return new RequestSecurityTokenResponseCollectionImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RSTRCollection), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE(RSTRCollection), e);
        }
    }

    public SecurityTokenReference createSecurityTokenReference(JAXBElement elem) {
        try {
            SecurityTokenReferenceType type = (SecurityTokenReferenceType)elem.getValue();
            return new SecurityTokenReferenceImpl(type);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE("STR"), e);
            throw new RuntimeException(LogStringsMessages.WST_0010_FAILED_CREATION_FROM_JAXBELE("STR"), e);
        }
    }

    public SecurityContextToken createSecurityContextToken(URI identifier, String instance, String wsuId) {
        throw new UnsupportedOperationException("this operation is not supported");
    }

    public JAXBElement toJAXBElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toJAXBElement((RequestSecurityToken)request);
        }
        return null;
    }

    public JAXBElement toJAXBElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toJAXBElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toJAXBElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public JAXBElement toJAXBElement(SecurityTokenReference str) {
        JAXBElement strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)str);
        return strElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityToken rst) {
        JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)rst);
        return rstElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityTokenResponse rstr) {
        JAXBElement<RequestSecurityTokenResponseType> rstElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
        return rstElement;
    }

    public JAXBElement toJAXBElement(Entropy entropy) {
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)entropy);
        return etElement;
    }

    public JAXBElement toJAXBElement(RequestSecurityTokenResponseCollection rstrCollection) {
        JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)rstrCollection);
        return rstElement;
    }

    public Source toSource(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toSource((RequestSecurityToken)request);
        }
        return null;
    }

    public Source toSource(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toSource((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toSource((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public Source toSource(RequestSecurityToken rst) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rst));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RST), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RST), ex);
        }
    }

    public Source toSource(RequestSecurityTokenResponse rstr) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rstr));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE("RSTR"), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE("RSTR"), ex);
        }
    }

    public Source toSource(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            return new JAXBSource(this.getMarshaller(), (Object)this.toJAXBElement(rstrCollection));
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RSTRCollection), ex);
            throw new RuntimeException(LogStringsMessages.WST_0002_FAIL_MARSHAL_TOSOURCE(RSTRCollection), ex);
        }
    }

    public Element toElement(BaseSTSRequest request) {
        if (request instanceof RequestSecurityToken) {
            return this.toElement((RequestSecurityToken)request);
        }
        return null;
    }

    public Element toElement(BaseSTSResponse response) {
        if (response instanceof RequestSecurityTokenResponse) {
            return this.toElement((RequestSecurityTokenResponse)response);
        }
        if (response instanceof RequestSecurityTokenResponseCollection) {
            return this.toElement((RequestSecurityTokenResponseCollection)response);
        }
        return null;
    }

    public Element toElement(RequestSecurityToken rst) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenType> rstElement = new ObjectFactory().createRequestSecurityToken((RequestSecurityTokenType)rst);
            this.getMarshaller().marshal(rstElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), e);
        }
    }

    public Element toElement(RequestSecurityTokenResponse rstr) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Element toElement(RequestSecurityTokenResponse rstr, Document doc) {
        try {
            JAXBElement<RequestSecurityTokenResponseType> rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
            this.getMarshaller().marshal(rstrElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Element toElement(RequestSecurityTokenResponseCollection rstrCollection) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<RequestSecurityTokenResponseCollectionType> rstElement = new ObjectFactory().createRequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)rstrCollection);
            this.getMarshaller().marshal(rstElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Element toElement(BinarySecret secret) {
        try {
            Document doc = WSTrustUtil.newDocument();
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)secret);
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Element toElement(SecurityTokenReference str, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement strElement = new com.sun.xml.ws.security.secext10.ObjectFactory().createSecurityTokenReference((SecurityTokenReferenceType)str);
            this.getMarshaller().marshal((Object)strElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Element toElement(BinarySecret secret, Document doc) {
        try {
            if (doc == null) {
                doc = WSTrustUtil.newDocument();
            }
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)secret);
            this.getMarshaller().marshal(bsElement, (Node)doc);
            return doc.getDocumentElement();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
            throw new RuntimeException(LogStringsMessages.WST_0012_JAXB_EX_TO_ELEMENT(), ex);
        }
    }

    public Marshaller getMarshaller() {
        try {
            Marshaller marshaller = WSTrustElementFactoryImpl.getContext().createMarshaller();
            marshaller.setProperty("org.glassfish.jaxb.runtime.marshaller.namespacePrefixMapper", (Object)new TrustNamespacePrefixMapper());
            return marshaller;
        }
        catch (PropertyException e) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), e);
        }
        catch (JAXBException jbe) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
            throw new RuntimeException(LogStringsMessages.WST_0003_ERROR_CREATING_WSTRUSTFACT(), jbe);
        }
    }
}

