/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SecurityContextToken
implements SecurityHeaderElement,
NamespaceContextInfo,
SecurityElementWriter,
com.sun.xml.ws.security.SecurityContextToken {
    private static final String IDENTIFIER = "Identifier".intern();
    private static final String INSTANCE = "Instance".intern();
    private static final int IDENTIFIER_ELEMENT = 1;
    private static final int INSTANCE_ELEMENT = 2;
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private String identifier = null;
    private String instance = null;
    private List extElements = null;
    private JAXBFilterProcessingContext pc;
    private MutableXMLStreamBuffer buffer = null;
    private HashMap<String, String> nsDecls;

    public SecurityContextToken(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap nsDecls) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.nsDecls = nsDecls;
        this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        this.buffer = new MutableXMLStreamBuffer();
        this.buffer.createFromXMLStreamReader(reader);
        StreamReaderBufferProcessor sct = this.buffer.readAsXMLStreamReader();
        sct.next();
        this.process((XMLStreamReader)sct);
    }

    public String getSCId() {
        return this.identifier;
    }

    @Override
    public URI getIdentifier() {
        try {
            return new URI(this.identifier);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public List getExtElements() {
        return this.extElements;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.buffer.writeToXMLStreamWriter(streamWriter);
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        if (StreamUtil.moveToNextElement(reader)) {
            int refElement = this.getEventType(reader);
            while (true) {
                if (reader.getEventType() == 8) break;
                switch (refElement) {
                    case 1: {
                        this.identifier = reader.getElementText();
                        break;
                    }
                    case 2: {
                        this.instance = reader.getElementText();
                        break;
                    }
                    default: {
                        throw new XWSSecurityException("Element name " + reader.getName() + " is not recognized under SecurityContextToken");
                    }
                }
                if (StreamUtil.moveToNextStartOREndElement(reader) && StreamUtil._break(reader, "SecurityContextToken", "http://schemas.xmlsoap.org/ws/2005/02/sc")) break;
                if (reader.getEventType() != 1) {
                    StreamUtil.moveToNextElement(reader);
                }
                refElement = this.getEventType(reader);
            }
        }
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == IDENTIFIER) {
                return 1;
            }
            if (reader.getLocalName() == INSTANCE) {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getWsuId() {
        return this.id;
    }

    @Override
    public String getType() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
    }

    @Override
    public Object getTokenValue() {
        return this;
    }
}

