/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class EncryptedTypeHeaderBlock
extends SecurityHeaderBlockImpl {
    SOAPElement encryptionMethod;
    KeyInfoHeaderBlock keyInfo;
    SOAPElement cipherData;
    SOAPElement encryptionProperties;
    boolean updateRequired = false;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    @Override
    public String getId() {
        String id = this.getAttribute("Id");
        if (id.equals("")) {
            return null;
        }
        return id;
    }

    public void setId(String id) {
        this.setAttribute("Id", id);
        this.setIdAttribute("Id", true);
    }

    public String getType() {
        String type = this.getAttribute("Type");
        if (type.equals("")) {
            return null;
        }
        return type;
    }

    public void setType(String type) {
        this.setAttribute("Type", type);
    }

    public String getMimeType() {
        String mimeType = this.getAttribute("MimeType");
        if (mimeType.equals("")) {
            return null;
        }
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.setAttribute("MimeType", mimeType);
    }

    public String getEncoding() {
        String encoding = this.getAttribute("Encoding");
        if (encoding.equals("")) {
            return null;
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.setAttribute("Encoding", encoding);
    }

    public SOAPElement getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String getEncryptionMethodURI() {
        if (this.encryptionMethod == null) {
            return null;
        }
        return this.encryptionMethod.getAttribute("Algorithm");
    }

    public void setEncryptionMethod(SOAPElement encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        this.updateRequired = true;
    }

    public void setEncryptionMethod(String algorithmURI) throws XWSSecurityException {
        try {
            this.encryptionMethod = EncryptedTypeHeaderBlock.getSoapFactory().createElement("EncryptionMethod", "xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0351.error.setting.encryption.method", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.encryptionMethod.setAttribute("Algorithm", algorithmURI);
        this.updateRequired = true;
    }

    public KeyInfoHeaderBlock getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfoHeaderBlock keyInfo) {
        this.keyInfo = keyInfo;
        this.updateRequired = true;
    }

    public String getCipherValue() throws XWSSecurityException {
        if (this.cipherData == null) {
            log.log(Level.SEVERE, "WSS0347.missing.cipher.data");
            throw new XWSSecurityException("Cipher data has not been set");
        }
        Iterator cipherValues = null;
        try {
            cipherValues = this.cipherData.getChildElements(EncryptedTypeHeaderBlock.getSoapFactory().createName("CipherValue", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0352.error.getting.cipherValue", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        if (!cipherValues.hasNext()) {
            log.log(Level.SEVERE, "WSS0353.missing.cipherValue");
            throw new XWSSecurityException("Cipher Value not present");
        }
        return this.getFullTextChildrenFromElement((Element)((SOAPElement)cipherValues.next()));
    }

    public SOAPElement getCipherData(boolean create) throws XWSSecurityException {
        if (this.cipherData == null && create) {
            try {
                this.cipherData = EncryptedTypeHeaderBlock.getSoapFactory().createElement("CipherData", "xenc", "http://www.w3.org/2001/04/xmlenc#");
            }
            catch (SOAPException e) {
                log.log(Level.SEVERE, "WSS0395.creating.cipherData");
                throw new XWSSecurityException((Throwable)e);
            }
        }
        return this.cipherData;
    }

    public SOAPElement getCipherReference(boolean create, String uri) throws XWSSecurityException {
        SOAPElement cipherReference = null;
        if (create) {
            try {
                cipherReference = EncryptedTypeHeaderBlock.getSoapFactory().createElement("CipherReference", "xenc", "http://www.w3.org/2001/04/xmlenc#");
                cipherReference.setAttribute("URI", uri);
                this.getCipherData(create).addChildElement(cipherReference);
            }
            catch (SOAPException e) {
                throw new XWSSecurityException((Throwable)e);
            }
        } else {
            if (this.cipherData == null) {
                throw new XWSSecurityException("CipherData is not present");
            }
            NodeList nl = this.cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
            if (nl.getLength() > 0) {
                return (SOAPElement)nl.item(0);
            }
        }
        return cipherReference;
    }

    public void addTransform(String algorithmURI) throws XWSSecurityException {
        SOAPElement cipherReference = this.getCipherReference(false, null);
        try {
            SOAPElement dsTransform = EncryptedTypeHeaderBlock.getSoapFactory().createElement("Transform", "ds", "http://www.w3.org/2000/09/xmldsig#");
            dsTransform.setAttribute("Algorithm", algorithmURI);
            SOAPElement xencTransforms = null;
            Iterator i = cipherReference.getChildElements();
            if (i == null || !i.hasNext()) {
                xencTransforms = EncryptedTypeHeaderBlock.getSoapFactory().createElement("Transforms", "xenc", "http://www.w3.org/2001/04/xmlenc#");
                xencTransforms = cipherReference.addChildElement(xencTransforms);
            } else {
                xencTransforms = (SOAPElement)i.next();
            }
            xencTransforms.addChildElement(dsTransform);
        }
        catch (SOAPException e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public Iterator getTransforms() throws XWSSecurityException {
        Iterator it;
        SOAPElement cr = this.getCipherReference(false, null);
        if (cr != null && (it = cr.getChildElements()).hasNext()) {
            SOAPElement transforms = (SOAPElement)it.next();
            return transforms.getChildElements();
        }
        return null;
    }

    public SOAPElement getEncryptionProperties() {
        return this.encryptionProperties;
    }

    public void setEncryptionProperties(SOAPElement encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        this.updateRequired = true;
    }

    public void saveChanges() {
        this.updateRequired = true;
    }

    public void initializeEncryptedType(SOAPElement element) throws XWSSecurityException {
        try {
            Iterator cnodes = element.getChildElements();
            while (cnodes.hasNext()) {
                Node se = (Node)cnodes.next();
                while (cnodes.hasNext() && se.getNodeType() != 1) {
                    se = (Node)cnodes.next();
                }
                if (se != null && se.getNodeType() == 1) {
                    if (((SOAPElement)se).getLocalName().equals("EncryptionMethod")) {
                        this.encryptionMethod = (SOAPElement)se;
                        continue;
                    }
                    if (((SOAPElement)se).getLocalName().equals("CipherData")) {
                        this.cipherData = (SOAPElement)se;
                        continue;
                    }
                    if (!((SOAPElement)se).getLocalName().equals("KeyInfo")) continue;
                    this.keyInfo = new KeyInfoHeaderBlock(new KeyInfo((Element)se, null));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0354.error.initializing.encryptedType", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    private String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        return sb.toString();
    }
}

