/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.MessageHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class RedeliveryTaskExecutor {
    private static final Logger LOGGER = Logger.getLogger(RedeliveryTaskExecutor.class);
    private static volatile DelayedTaskManager delayedTaskManager;

    private RedeliveryTaskExecutor() {
    }

    public static boolean deliverUsingCurrentThread(ApplicationMessage message, long delay, TimeUnit timeUnit, MessageHandler messageHandler) {
        try {
            Thread.sleep(timeUnit.toMillis(delay));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Attempting redelivery of a message with number [ %d ] on a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
        }
        messageHandler.putToDeliveryQueue(message);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean register(final ApplicationMessage message, long delay, TimeUnit timeUnit, final MessageHandler messageHandler, Component container) {
        final HaContext.State state = HaContext.currentState();
        if (delayedTaskManager == null) {
            Class<RedeliveryTaskExecutor> clazz = RedeliveryTaskExecutor.class;
            // MONITORENTER : com.sun.xml.ws.rx.rm.runtime.RedeliveryTaskExecutor.class
            if (delayedTaskManager == null) {
                delayedTaskManager = DelayedTaskManager.createManager((String)"redelivery-task-executor", (int)5, (Component)container);
            }
            // MONITOREXIT : clazz
        }
        if (!LOGGER.isLoggable(Level.FINER)) return delayedTaskManager.register(new DelayedTaskManager.DelayedTask(){

            public void run(DelayedTaskManager manager) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("Attempting redelivery of a message with number [ %d ] on a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
                }
                HaContext.State oldState = HaContext.initFrom((HaContext.State)state);
                try {
                    messageHandler.putToDeliveryQueue(message);
                }
                finally {
                    HaContext.initFrom((HaContext.State)oldState);
                }
            }

            public String getName() {
                return String.format("redelivery of a message with number [ %d ] on a sequenece [ %s ]", message.getMessageNumber(), message.getSequenceId());
            }
        }, delay, timeUnit);
        LOGGER.finer(String.format("A message with number [ %d ] has been scheduled for a redelivery on a sequence [ %s ] with a delay of %d %s using current HA context state [ %s ]", message.getMessageNumber(), message.getSequenceId(), delay, timeUnit.toString().toLowerCase(), state.toString()));
        return delayedTaskManager.register(new /* invalid duplicate definition of identical inner class */, delay, timeUnit);
    }
}

