/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.security.core.dsig.ObjectFactory;
import com.sun.xml.security.core.xenc.CipherDataType;
import com.sun.xml.security.core.xenc.EncryptedDataType;
import com.sun.xml.security.core.xenc.EncryptionMethodType;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.Signature;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.DSAKeyValue;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyValue;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.RSAKeyValue;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.X509Data;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBSignContext;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBSignatureFactory;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.dsig.EnvelopedSignedMessageHeader;
import com.sun.xml.ws.security.opt.impl.dsig.JAXBSignatureHeaderElement;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedData;
import com.sun.xml.ws.security.opt.impl.keyinfo.SAMLToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.impl.IssueSamlTokenContract;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.saml.Advice;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.Attribute;
import com.sun.xml.wss.saml.AttributeStatement;
import com.sun.xml.wss.saml.Conditions;
import com.sun.xml.wss.saml.NameID;
import com.sun.xml.wss.saml.NameIdentifier;
import com.sun.xml.wss.saml.SAMLAssertionFactory;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.Subject;
import com.sun.xml.wss.saml.SubjectConfirmation;
import com.sun.xml.wss.saml.SubjectConfirmationData;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;

public class SBIssuedSamlTokenContractImpl
extends IssueSamlTokenContract {
    private static final String SAML_HOLDER_OF_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    protected static final String PRINCIPAL = "principal";
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    WSSElementFactory wef = new WSSElementFactory(SOAPVersion.SOAP_11);
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public SBIssuedSamlTokenContractImpl(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public SBIssuedSamlTokenContractImpl() {
    }

    @Override
    public Token createSAMLAssertion(String appliesTo, String tokenType, String keyType, String assertionId, String issuer, Map<QName, List<String>> claimedAttrs, IssuedTokenContext context) throws WSTrustException {
        GenericToken token = null;
        CallbackHandler callbackHandler = this.stsConfig.getCallbackHandler();
        try {
            NamespaceContextEx nsContext = null;
            nsContext = this.soapVersion == SOAPVersion.SOAP_11 ? new NamespaceContextEx() : new NamespaceContextEx(true);
            nsContext.addEncryptionNS();
            nsContext.addExc14NS();
            nsContext.addSAMLNS();
            nsContext.addSignatureNS();
            nsContext.addWSSNS();
            X509Certificate serCert = this.getServiceCertificate(callbackHandler, this.stsConfig.getTrustSPMetadata(appliesTo), appliesTo);
            KeyInfo keyInfo = this.createKeyInfo(keyType, serCert, context);
            Assertion assertion = null;
            SAMLToken samlToken = null;
            if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
                assertion = this.createSAML11Assertion(assertionId, issuer, appliesTo, keyInfo, claimedAttrs);
                samlToken = new SAMLToken(assertion, SAMLJAXBUtil.getJAXBContext(), this.soapVersion);
            } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                assertion = this.createSAML20Assertion(assertionId, issuer, appliesTo, keyInfo, claimedAttrs);
                samlToken = new SAMLToken(assertion, SAMLJAXBUtil.getJAXBContext(), this.soapVersion);
            } else {
                log.log(Level.SEVERE, LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
                throw new WSTrustException(LogStringsMessages.WST_0031_UNSUPPORTED_TOKEN_TYPE(tokenType, appliesTo));
            }
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            SignatureKeyCallback skc = new SignatureKeyCallback(request);
            Callback[] callbacks = new Callback[]{skc};
            callbackHandler.handle(callbacks);
            PrivateKey stsPrivKey = request.getPrivateKey();
            SecurityHeaderElement signedAssertion = this.createSignature(request.getX509Certificate().getPublicKey(), stsPrivKey, samlToken, nsContext);
            token = new GenericToken(signedAssertion);
            if (this.stsConfig.getEncryptIssuedToken()) {
                String id = "uuid-" + UUID.randomUUID().toString();
                int keysizeInBytes = 32;
                byte[] skey = WSTrustUtil.generateRandomSecret(32);
                SecretKeySpec key = new SecretKeySpec(skey, "AES");
                KeyInfo encKeyInfo = new KeyInfo();
                EncryptedKey encKey = this.encryptKey(key, serCert);
                encKeyInfo.getContent().add(encKey);
                EncryptedDataType edt = this.createEncryptedData(id, "http://www.w3.org/2001/04/xmlenc#aes256-cbc", encKeyInfo, false);
                JAXBEncryptedData jed = new JAXBEncryptedData(edt, new SSEData(signedAssertion, false, nsContext), this.soapVersion);
                token = new GenericToken(jed);
            } else {
                token = new GenericToken(signedAssertion);
            }
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        return token;
    }

    private Assertion createSAML11Assertion(String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs) throws WSTrustException {
        Assertion assertion = null;
        try {
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml1.1");
            GregorianCalendar issuerInst = new GregorianCalendar();
            GregorianCalendar notOnOrAfter = new GregorianCalendar();
            notOnOrAfter.add(14, (int)this.stsConfig.getIssuedTokenTimeout());
            Conditions conditions = samlFac.createConditions(issuerInst, notOnOrAfter, null, null, null);
            Advice advice = samlFac.createAdvice(null, null, null);
            ArrayList<String> confirmMethods = new ArrayList<String>();
            confirmMethods.add(SAML_HOLDER_OF_KEY);
            SubjectConfirmation subjectConfirm = samlFac.createSubjectConfirmation(confirmMethods, null, keyInfo);
            Subject subj = null;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0) continue;
                if ("NameID".equals(attrKey.getLocalPart()) && subj == null) {
                    NameIdentifier nameId = samlFac.createNameIdentifier(values.get(0), attrKey.getNamespaceURI(), null);
                    subj = samlFac.createSubject(nameId, subjectConfirm);
                    continue;
                }
                Attribute attr = samlFac.createAttribute(attrKey.getLocalPart(), attrKey.getNamespaceURI(), values);
                attrs.add(attr);
            }
            AttributeStatement statement = samlFac.createAttributeStatement(subj, attrs);
            ArrayList<AttributeStatement> statements = new ArrayList<AttributeStatement>();
            statements.add(statement);
            assertion = samlFac.createAssertion(assertionId, issuer, issuerInst, conditions, advice, statements);
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        return assertion;
    }

    private Assertion createSAML20Assertion(String assertionId, String issuer, String appliesTo, KeyInfo keyInfo, Map<QName, List<String>> claimedAttrs) throws WSTrustException {
        Assertion assertion = null;
        try {
            SAMLAssertionFactory samlFac = SAMLAssertionFactory.newInstance("Saml2.0");
            GregorianCalendar issueInst = new GregorianCalendar();
            GregorianCalendar notOnOrAfter = new GregorianCalendar();
            notOnOrAfter.add(14, (int)this.stsConfig.getIssuedTokenTimeout());
            Conditions conditions = samlFac.createConditions(issueInst, notOnOrAfter, null, null, null, null);
            SubjectConfirmationData subjComfData = samlFac.createSubjectConfirmationData(null, null, issueInst, notOnOrAfter, appliesTo, keyInfo);
            SubjectConfirmation subConfirmation = samlFac.createSubjectConfirmation(null, subjComfData, SAML_HOLDER_OF_KEY);
            Subject subj = null;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
            for (Map.Entry<QName, List<String>> entry : entries) {
                QName attrKey = entry.getKey();
                List<String> values = entry.getValue();
                if (values == null || values.size() <= 0) continue;
                if ("NameID".equals(attrKey.getLocalPart()) && subj == null) {
                    NameIdentifier nameId = samlFac.createNameIdentifier(values.get(0), attrKey.getNamespaceURI(), null);
                    subj = samlFac.createSubject(nameId, subConfirmation);
                    continue;
                }
                Attribute attr = samlFac.createAttribute(attrKey.getLocalPart(), values);
                attrs.add(attr);
            }
            AttributeStatement statement = samlFac.createAttributeStatement(attrs);
            ArrayList<AttributeStatement> statements = new ArrayList<AttributeStatement>();
            statements.add(statement);
            NameID issuerID = samlFac.createNameID(issuer, null, null);
            assertion = samlFac.createAssertion(assertionId, issuerID, issueInst, conditions, null, subj, statements);
        }
        catch (SAMLException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0032_ERROR_CREATING_SAML_ASSERTION(), (Throwable)ex);
        }
        return assertion;
    }

    private KeyInfo createKeyInfo(String keyType, X509Certificate serCert, IssuedTokenContext ctx) throws WSTrustException {
        KeyInfo keyInfo = new KeyInfo();
        if ("http://schemas.xmlsoap.org/ws/2005/02/trust/SymmetricKey".equals(keyType)) {
            byte[] key = ctx.getProofKey();
            if (!this.stsConfig.getEncryptIssuedToken() && this.stsConfig.getEncryptIssuedKey()) {
                try {
                    SecretKeySpec secKey = new SecretKeySpec(key, "AES");
                    EncryptedKey encKey = this.encryptKey(secKey, serCert);
                    keyInfo.getContent().add(encKey);
                }
                catch (Exception ex) {
                    throw new WSTrustException(ex.getMessage(), (Throwable)ex);
                }
            } else {
                BinarySecret secret = this.eleFac.createBinarySecret(key, this.wstVer.getSymmetricKeyTypeURI());
                keyInfo.getContent().add(secret);
            }
        } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey".equals(keyType)) {
            X509Data x509Data = new X509Data();
            Set<Object> certs = ctx.getRequestorSubject().getPublicCredentials();
            if (certs == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
            boolean addedClientCert = false;
            ObjectFactory dsigOF = new ObjectFactory();
            for (Object o : certs) {
                JAXBElement<byte[]> certElement;
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate clientCert = (X509Certificate)o;
                try {
                    certElement = dsigOF.createX509DataTypeX509Certificate(clientCert.getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    throw new WSTrustException("Unable to create KeyInfo", (Throwable)ex);
                }
                List x509DataContent = x509Data.getContent();
                x509DataContent.add(certElement);
                addedClientCert = true;
            }
            if (!addedClientCert) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
            keyInfo.getContent().add(x509Data);
        }
        return keyInfo;
    }

    private EncryptedKey encryptKey(Key key, X509Certificate cert) throws XWSSecurityException {
        KeyInfo keyInfo = null;
        KeyIdentifier keyIdentifier = this.wef.createKeyIdentifier();
        keyIdentifier.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
        keyIdentifier.updateReferenceValue(cert);
        keyIdentifier.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        SecurityTokenReference str = this.wef.createSecurityTokenReference(keyIdentifier);
        keyInfo = this.wef.createKeyInfo(str);
        return this.wef.createEncryptedKey(null, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", keyInfo, cert.getPublicKey(), key);
    }

    private X509Certificate getServiceCertificate(CallbackHandler callbackHandler, TrustSPMetadata spMd, String appliesTo) throws WSTrustException {
        EncryptionKeyCallback.AliasX509CertificateRequest req = new EncryptionKeyCallback.AliasX509CertificateRequest(spMd.getCertAlias());
        EncryptionKeyCallback callback = new EncryptionKeyCallback(req);
        Callback[] callbacks = new Callback[]{callback};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), (Throwable)ex);
        }
        catch (UnsupportedCallbackException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), (Throwable)ex);
        }
        return req.getX509Certificate();
    }

    public EncryptedDataType createEncryptedData(String id, String dataEncAlgo, KeyInfo keyInfo, boolean contentOnly) {
        EncryptedDataType edt = new EncryptedDataType();
        if (contentOnly) {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Content");
        } else {
            edt.setType("http://www.w3.org/2001/04/xmlenc#Element");
        }
        EncryptionMethodType emt = new EncryptionMethodType();
        emt.setAlgorithm(dataEncAlgo);
        edt.setEncryptionMethod(emt);
        CipherDataType cipherType = new CipherDataType();
        cipherType.setCipherValue("ed".getBytes());
        edt.setCipherData(cipherType);
        edt.setId(id);
        if (keyInfo != null) {
            edt.setKeyInfo(keyInfo);
        }
        return edt;
    }

    private SecurityHeaderElement createSignature(PublicKey pubKey, Key signingKey, SAMLToken samlToken, NamespaceContextEx nsContext) throws WSTrustException {
        try {
            KeyValue keyValue;
            PublicKey key;
            JAXBSignatureFactory signatureFactory = JAXBSignatureFactory.newInstance();
            C14NMethodParameterSpec spec = null;
            CanonicalizationMethod canonicalMethod = signatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", spec);
            DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            SignatureMethod signatureMethod = signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            ArrayList<Transform> transformList = new ArrayList<Transform>();
            Transform tr1 = signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            Transform tr2 = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
            transformList.add(tr1);
            transformList.add(tr2);
            String uri = "#uuid-" + UUID.randomUUID().toString();
            Reference ref = signatureFactory.newReference(uri, digestMethod, transformList, (String)null, (String)null);
            SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalMethod, signatureMethod, Collections.singletonList(ref));
            if (pubKey instanceof DSAPublicKey) {
                DSAKeyValue dsa = null;
                key = (DSAPublicKey)pubKey;
                byte[] paramP = key.getParams().getP().toByteArray();
                byte[] paramQ = key.getParams().getQ().toByteArray();
                byte[] paramG = key.getParams().getG().toByteArray();
                byte[] paramY = key.getY().toByteArray();
                dsa = signatureFactory.newDSAKeyValue(paramP, paramQ, paramG, paramY, null, null, null);
                keyValue = signatureFactory.newKeyValue(Collections.singletonList(dsa));
            } else if (pubKey instanceof RSAPublicKey) {
                RSAKeyValue rsa = null;
                key = (RSAPublicKey)pubKey;
                rsa = signatureFactory.newRSAKeyValue(key.getModulus().toByteArray(), key.getPublicExponent().toByteArray());
                keyValue = signatureFactory.newKeyValue(Collections.singletonList(rsa));
            } else {
                throw new WSTrustException("Unsupported PublicKey");
            }
            javax.xml.crypto.dsig.keyinfo.KeyInfo keyInfo = signatureFactory.newKeyInfo(Collections.singletonList(keyValue));
            JAXBSignContext signContext = new JAXBSignContext(signingKey);
            Data data = null;
            signContext.setURIDereferencer(new DSigResolver(data));
            Signature signature = (Signature)signatureFactory.newXMLSignature(signedInfo, keyInfo);
            JAXBSignatureHeaderElement jhe = new JAXBSignatureHeaderElement(signature, this.soapVersion, signContext);
            return new EnvelopedSignedMessageHeader(samlToken, (com.sun.xml.ws.security.opt.crypto.dsig.Reference)ref, jhe, nsContext);
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0035_UNABLE_CREATE_SIGN_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0035_UNABLE_CREATE_SIGN_SAML_ASSERTION(), (Throwable)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0035_UNABLE_CREATE_SIGN_SAML_ASSERTION(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0035_UNABLE_CREATE_SIGN_SAML_ASSERTION(), (Throwable)ex);
        }
    }

    private static class DSigResolver
    implements URIDereferencer {
        public Data data = null;

        DSigResolver(Data data) {
            this.data = data;
        }

        @Override
        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
            return this.data;
        }
    }
}

