/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.dev.ProtocolMessageHandler;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.McResponseHandlerBase;
import com.sun.xml.ws.rx.util.ResumeFiberException;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.Map;
import javax.xml.soap.SOAPException;

class WsMcResponseHandler
extends McResponseHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(WsMcResponseHandler.class);
    private final Map<String, ProtocolMessageHandler> actionToProtocolHandlerMap;

    public WsMcResponseHandler(McConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage, Map<String, ProtocolMessageHandler> protocolHandlerMap) {
        super(configuration, mcSenderTask, suspendedFiberStorage);
        this.actionToProtocolHandlerMap = protocolHandlerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onCompletion(Packet response) {
        try {
            responseMessage = response.getMessage();
            if (responseMessage == null) {
                WsMcResponseHandler.LOGGER.warning(LocalizationMessages.WSMC_0112_NO_RESPONSE_RETURNED());
                return;
            }
            if (!responseMessage.hasHeaders()) {
                WsMcResponseHandler.LOGGER.severe(LocalizationMessages.WSMC_0113_NO_WSMC_HEADERS_IN_RESPONSE());
                return;
            }
            super.processMakeConnectionHeaders(responseMessage);
            if (responseMessage.isFault() && this.configuration.getRuntimeVersion().protocolVersion.isFault(faultAction = AddressingUtils.getAction((MessageHeaders)responseMessage.getHeaders(), (AddressingVersion)this.configuration.getAddressingVersion(), (SOAPVersion)this.configuration.getSoapVersion()))) {
                fault = null;
                try {
                    fault = responseMessage.readAsSOAPMessage().getSOAPBody().getFault();
                }
                catch (SOAPException ex) {
                    throw (RxRuntimeException)WsMcResponseHandler.LOGGER.logSevereException((Throwable)new RxRuntimeException(LocalizationMessages.WSMC_0114_ERROR_UNMARSHALLING_SOAP_FAULT(), ex));
                }
                throw (RxRuntimeException)WsMcResponseHandler.LOGGER.logSevereException((Throwable)new RxRuntimeException(LocalizationMessages.WSMC_0115_UNEXPECTED_PROTOCOL_ERROR(fault.getFaultString())));
            }
            wsaRelatesToHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().relatesToTag, false);
            if (wsaRelatesToHeader == null) ** GOTO lbl27
            this.setCorrelationId(wsaRelatesToHeader.getStringContent());
            try {
                this.resumeParentFiber(response);
                return;
            }
            catch (ResumeFiberException ex) {
                WsMcResponseHandler.LOGGER.warning(LocalizationMessages.WSMC_0116_RESUME_PARENT_FIBER_ERROR(), (Throwable)ex);
lbl27:
                // 2 sources

                WsMcResponseHandler.LOGGER.finer(LocalizationMessages.WSMC_0117_PROCESSING_RESPONSE_AS_PROTOCOL_MESSAGE());
                wsaActionHeader = responseMessage.getHeaders().get(this.configuration.getAddressingVersion().actionTag, false);
                if (wsaActionHeader != null) {
                    wsaAction = wsaActionHeader.getStringContent();
                    handler = this.actionToProtocolHandlerMap.get(wsaAction);
                    if (handler != null) {
                        WsMcResponseHandler.LOGGER.finer(LocalizationMessages.WSMC_0118_PROCESSING_RESPONSE_IN_PROTOCOL_HANDLER(wsaAction, handler.getClass().getName()));
                        handler.processProtocolMessage(response);
                    } else {
                        WsMcResponseHandler.LOGGER.warning(LocalizationMessages.WSMC_0119_UNABLE_TO_FIND_PROTOCOL_HANDLER(wsaAction));
                    }
                } else {
                    WsMcResponseHandler.LOGGER.severe(LocalizationMessages.WSMC_0120_WSA_ACTION_HEADER_MISSING());
                }
            }
        }
        finally {
            this.mcSenderTask.clearMcRequestPendingFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Throwable error) {
        try {
            LOGGER.warning(LocalizationMessages.WSMC_0121_FAILED_TO_SEND_WSMC_REQUEST(), error);
            this.suspendedFiberStorage.resumeAllFibers(error);
        }
        finally {
            this.mcSenderTask.clearMcRequestPendingFlag();
        }
    }
}

