/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.NotificationBuilder;
import com.sun.xml.ws.tx.at.common.WSATVersion10;
import com.sun.xml.ws.tx.at.common.WSATVersion11;
import com.sun.xml.ws.tx.at.common.client.CoordinatorProxyBuilder;
import com.sun.xml.ws.tx.at.common.client.ParticipantProxyBuilder;
import com.sun.xml.ws.tx.at.v10.types.Notification;
import com.sun.xml.ws.tx.coord.common.EndpointReferenceBuilder;
import javax.xml.ws.WebServiceFeature;

public abstract class WSATVersion<T> {
    public static final WSATVersion<Notification> v10 = new WSATVersion10();
    public static final WSATVersion<com.sun.xml.ws.tx.at.v11.types.Notification> v11 = new WSATVersion11();
    private Transactional.Version version;
    protected AddressingVersion addressingVersion;
    protected SOAPVersion soapVersion;

    public static WSATVersion getInstance(Transactional.Version version) {
        if (Transactional.Version.WSAT10 == version || Transactional.Version.DEFAULT == version) {
            return v10;
        }
        if (Transactional.Version.WSAT11 == version || Transactional.Version.WSAT12 == version) {
            return v11;
        }
        throw new IllegalArgumentException(version + "is not a supported ws-at version");
    }

    WSATVersion(Transactional.Version version) {
        this.version = version;
    }

    public abstract WSATHelper getWSATHelper();

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public SOAPVersion getSOPAVersion() {
        return this.soapVersion;
    }

    public Transactional.Version getVersion() {
        return this.version;
    }

    public abstract CoordinatorProxyBuilder<T> newCoordinatorProxyBuilder();

    public abstract ParticipantProxyBuilder<T> newParticipantProxyBuilder();

    public abstract NotificationBuilder<T> newNotificationBuilder();

    public abstract EndpointReferenceBuilder newEndpointReferenceBuilder();

    public abstract WebServiceFeature newAddressingFeature();
}

