/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.NamedThreadFactory;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;

public final class Postman {
    private static final Logger LOGGER = Logger.getLogger(Postman.class);
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("postman-executor"));

    Postman() {
    }

    public void deliver(final ApplicationMessage message, final Callback deliveryCallback) {
        final HaContext.State state = HaContext.currentState();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Scheduling delivery execution of a message with number [ %d ] on a sequence [ %s ] using current HA context state [ %s ]", message.getMessageNumber(), message.getSequenceId(), state.toString()));
        }
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("Executing delivery of a message with number [ %d ] on a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
                }
                HaContext.State oldState = HaContext.initFrom((HaContext.State)state);
                try {
                    deliveryCallback.deliver(message);
                }
                finally {
                    HaContext.initFrom((HaContext.State)oldState);
                }
            }
        });
    }

    public static interface Callback {
        public void deliver(ApplicationMessage var1);
    }
}

