/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.persistence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.metro.api.config.management.ConfigSaver;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.metro.api.config.management.NamedParameters;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.sourcemodel.attach.ExternalAttachmentsUnmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConfigSaver<T>
implements ConfigSaver<T> {
    private static final Logger LOGGER = Logger.getLogger(JDBCConfigSaver.class);
    private ManagedEndpoint<T> endpoint;
    private ManagedServiceAssertion assertion;

    public void init(ManagedEndpoint<T> endpoint, ManagedServiceAssertion assertion) {
        this.endpoint = endpoint;
        this.assertion = assertion;
    }

    public void persist(NamedParameters parameters) {
        String newConfig = (String)parameters.get("CONFIGURATION_DATA");
        JDBCConfigSaver.validate(newConfig);
        Connection connection = null;
        DataSource source = null;
        try {
            ManagedServiceAssertion.ImplementationRecord record = this.assertion.getConfigSaverImplementation();
            source = ManagementUtil.getJdbcDataSource(record, JDBCConfigSaver.class.getName());
            connection = source.getConnection();
            ManagementUtil.JdbcTableNames tableNames = ManagementUtil.getJdbcTableNames(record, JDBCConfigSaver.class.getName());
            JDBCConfigSaver.writeData(connection, tableNames, this.endpoint.getId(), newConfig);
        }
        catch (SQLException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5021_NO_DB_CONNECT(source), (Throwable)e));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOGGER.warning(ManagementMessages.WSM_5022_NO_DB_CLOSE((Object)connection), (Throwable)e);
            }
        }
    }

    private static void validate(String configData) throws WebServiceException {
        try {
            ExternalAttachmentsUnmarshaller.unmarshal((Reader)new StringReader(configData));
        }
        catch (PolicyException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5097_FAILED_CONFIG_PARSE(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeData(Connection connection, ManagementUtil.JdbcTableNames tableNames, String endpointId, String config) {
        Statement updateStatement = null;
        Statement insertStatement = null;
        try {
            int rowCount;
            String update = "UPDATE " + tableNames.getTableName() + " SET " + tableNames.getVersionName() + " = " + tableNames.getVersionName() + " + 1, " + tableNames.getConfigName() + " = ? WHERE id = ?";
            updateStatement = connection.prepareStatement(update);
            updateStatement.setCharacterStream(1, new StringReader(config), config.length());
            updateStatement.setString(2, endpointId);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5023_EXECUTE_SQL((Object)update));
            }
            if ((rowCount = updateStatement.executeUpdate()) != 0) return;
            String insert = "INSERT INTO " + tableNames.getTableName() + " (" + tableNames.getIdName() + ", " + tableNames.getVersionName() + ", " + tableNames.getConfigName() + ") VALUES (?, 1, ?)";
            insertStatement = connection.prepareStatement(insert);
            insertStatement.setString(1, endpointId);
            insertStatement.setCharacterStream(2, new StringReader(config), config.length());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5024_EXECUTE_SQL_UPDATE((Object)insert));
            }
            insertStatement.executeUpdate();
            return;
        }
        catch (SQLException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5025_SQL_FAILED(), (Throwable)e));
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
            }
            catch (SQLException e) {
                LOGGER.warning(ManagementMessages.WSM_5026_FAILED_STATEMENT_CLOSE((Object)updateStatement), (Throwable)e);
            }
            finally {
                try {
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.warning(ManagementMessages.WSM_5026_FAILED_STATEMENT_CLOSE((Object)insertStatement), (Throwable)e);
                }
            }
        }
    }
}

