/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust;

import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;

public class GenericToken
implements Token {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private Object token;
    private String tokenType;
    private SecurityHeaderElement she = null;
    private String id;

    public GenericToken(Element token) {
        this.token = token;
        this.id = token.getAttributeNS(null, "AssertionID");
        if (this.id == null || this.id.length() == 0) {
            this.id = token.getAttributeNS(null, "ID");
        }
        if (this.id == null || this.id.length() == 0) {
            this.id = token.getAttributeNS(null, "Id");
        }
        if (this.id == null || this.id.length() == 0) {
            this.id = UUID.randomUUID().toString();
        }
    }

    public GenericToken(JAXBElement token) {
        this.token = token;
    }

    public GenericToken(Element token, String tokenType) {
        this(token);
        this.tokenType = tokenType;
    }

    public GenericToken(SecurityHeaderElement headerElement) {
        this.she = headerElement;
    }

    public String getType() {
        if (this.tokenType != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1001_TOKEN_TYPE(this.tokenType));
            }
            return this.tokenType;
        }
        return "opaque";
    }

    public Object getTokenValue() {
        return this.token;
    }

    public SecurityHeaderElement getElement() {
        return this.she;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

