/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedData;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedHeader
implements SecurityHeaderElement,
SecurityElementWriter {
    private JAXBFilterProcessingContext pc = null;
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private EncryptedData ed = null;
    private HashMap<String, String> parentNS = null;

    public EncryptedHeader(XMLStreamReader reader, JAXBFilterProcessingContext pc, HashMap<String, String> parentNS) throws XMLStreamException, XWSSecurityException {
        this.pc = pc;
        this.parentNS = parentNS;
        this.process(reader);
    }

    public EncryptedData getEncryptedData() {
        return this.ed;
    }

    public String getEncryptionAlgorithm() {
        return this.ed.getEncryptionAlgorithm();
    }

    public Key getKey() {
        return this.ed.getKey();
    }

    public InputStream getCipherInputStream() throws XWSSecurityException {
        return this.ed.getCipherInputStream();
    }

    public InputStream getCipherInputStream(Key key) throws XWSSecurityException {
        return this.ed.getCipherInputStream(key);
    }

    public XMLStreamReader getDecryptedData() throws XMLStreamException, XWSSecurityException {
        return this.ed.getDecryptedData();
    }

    public XMLStreamReader getDecryptedData(Key key) throws XMLStreamException, XWSSecurityException {
        return this.ed.getDecryptedData(key);
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    private void process(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        while (reader.hasNext()) {
            reader.next();
            if (reader.getEventType() == 1 && "EncryptedData".equals(reader.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(reader.getNamespaceURI())) {
                this.ed = new EncryptedData(reader, this.pc, this.parentNS);
            }
            if (reader.getEventType() != 2 || !"EncryptedHeader".equals(reader.getLocalName()) || !"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd".equals(reader.getNamespaceURI())) continue;
            break;
        }
    }

    public WSSPolicy getInferredKB() {
        return this.ed.getInferredKB();
    }
}

