/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.plugins;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.tools.plugin.ToolPlugin;
import com.sun.xml.rpc.tools.wscompile.ModelIf;
import com.sun.xml.rpc.tools.wscompile.StubHooksIf;
import com.sun.xml.rpc.tools.wscompile.TieHooksIf;
import com.sun.xml.rpc.tools.wscompile.UsageIf;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SecurityPlugin
extends ToolPlugin
implements UsageIf,
ModelIf,
StubHooksIf,
TieHooksIf {
    private File securityFile = null;
    private LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.plugins.sec");
    private static final String sec_util = "secPgUtil";
    private static final String sec_util_pkg = "com.sun.xml.rpc.security";
    private static final String SECURITY_PROPERTY = "com.sun.xml.rpc.security";

    public Localizable getOptionsUsage() {
        return this.messageFactory.getMessage("sec.usage.options", (Object[])null);
    }

    public Localizable getFeaturesUsage() {
        return null;
    }

    public Localizable getInternalUsage() {
        return null;
    }

    public Localizable getExamplesUsage() {
        return null;
    }

    public boolean parseArguments(String[] args, UsageIf.UsageError err) {
        this.securityFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals("-security")) continue;
            if (i + 1 < args.length) {
                if (this.securityFile != null) {
                    err.msg = this.messageFactory.getMessage("sec.duplicateOption", new Object[]{"-security"});
                    return false;
                }
                args[i] = null;
                this.securityFile = new File(args[++i]);
                args[i] = null;
                continue;
            }
            err.msg = this.messageFactory.getMessage("sec.missingOptionArgument", new Object[]{"-security"});
            return false;
        }
        return true;
    }

    public void updateModel(ModelIf.ModelProperty property) {
        if (this.securityFile != null) {
            property.attr = "com.sun.xml.rpc.security";
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(this.securityFile));
                byte[] xmlBytes = new byte[(int)this.securityFile.length()];
                in.readFully(xmlBytes);
                in.close();
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                ((DocumentBuilderFactory)factory).setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.FALSE);
                ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                InputStream is = SecurityPlugin.class.getResourceAsStream("xwssconfig.xsd");
                boolean validate = true;
                try {
                    InputStream isV = SecurityPlugin.class.getResourceAsStream("disablevalidation.xml");
                    if (isV != null) {
                        validate = false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (validate) {
                    ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
                    factory.setValidating(true);
                    factory.setIgnoringComments(true);
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                    builder.setErrorHandler(new ErrorHandler(System.out));
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
                    builder.parse(inputStream);
                }
                property.value = this.processString(new String(xmlBytes));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void _preHandlingHook(Model model, IndentingWriter p, StubHooksIf.StubHooksState state) throws IOException {
        String config = (String)model.getProperty("com.sun.xml.rpc.security");
        if (config != null) {
            p.pln("//Generated by security plugin");
            this.writeCheckMustUnderstandInStub(p);
            p.pln("secPgUtil._preHandlingHook(state);");
            p.pln("super._preHandlingHook(state);");
            p.flush();
            state.superDone = true;
        }
    }

    public void _preRequestSendingHook(Model model, IndentingWriter p, StubHooksIf.StubHooksState state) throws IOException {
        String config = (String)model.getProperty("com.sun.xml.rpc.security");
        if (config != null) {
            p.pln("//Generated by security plugin");
            p.pln("super._preRequestSendingHook(state);");
            p.pln("bool = secPgUtil._preRequestSendingHook(state);");
            p.flush();
            state.superDone = true;
        }
    }

    public void preHandlingHook(Model model, IndentingWriter p, TieHooksIf.TieHooksState state) throws IOException {
        String config = (String)model.getProperty("com.sun.xml.rpc.security");
        if (config != null) {
            p.pln("//Generated by security plugin");
            this.writeCheckMustUnderstandInTie(p);
            p.plnI("try {");
            p.pln("if (!secPgUtil.preHandlingHook(state)) return false;");
            p.pOlnI("} catch (javax.xml.rpc.soap.SOAPFaultException sfe) {");
            p.pln("SOAPFaultInfo fault = new SOAPFaultInfo(sfe.getFaultCode(), sfe.getFaultString(), sfe.getFaultActor());");
            p.pln("reportFault(fault, state);");
            p.pln("return false;");
            p.pOln("}");
            p.pln("bool = super.preHandlingHook(state);");
            p.flush();
            state.superDone = true;
        }
    }

    public void postResponseWritingHook(Model model, IndentingWriter p, TieHooksIf.TieHooksState state) throws IOException {
        String config = (String)model.getProperty("com.sun.xml.rpc.security");
        if (config != null) {
            p.pln("//Generated by security plugin");
            p.pln("super.postResponseWritingHook(state);");
            p.pln("secPgUtil.postResponseWritingHook(state);");
            p.flush();
            state.superDone = true;
        }
    }

    public void writeStubStatic(Model model, IndentingWriter p) throws IOException {
    }

    public void writeTieStatic(Model model, IndentingWriter p) throws IOException {
    }

    public void writeStubStatic(Model model, Port port, IndentingWriter p) throws IOException {
        this.writeStatics(model, port, p, true);
    }

    public void writeTieStatic(Model model, Port port, IndentingWriter p) throws IOException {
        this.writeStatics(model, port, p, false);
    }

    private void writeStatics(Model model, Port port, IndentingWriter p, boolean isStub) throws IOException {
        String config = (String)model.getProperty("com.sun.xml.rpc.security");
        if (config != null) {
            config = "\"[version 1.0 FCS]" + config + "\"";
            String decl = "private static com.sun.xml.rpc.security.SecurityPluginUtil secPgUtil;";
            String block_begin = "static {";
            String block_body1 = "try {";
            String block_body2 = "secPgUtil = new com.sun.xml.rpc.security.SecurityPluginUtil(" + config + ", \"" + port.getName() + "\"" + ", " + Boolean.valueOf(isStub) + ");";
            String block_body3 = "} catch (Exception e) {";
            String block_body4 = "e.printStackTrace();";
            String block_body5 = "throw new RuntimeException(e);";
            String block_body6 = "}";
            String block_end = "}";
            p.pln(decl);
            p.pln();
            p.plnI(block_begin);
            p.plnI(block_body1);
            p.flush();
            char[] array = block_body2.toCharArray();
            for (int i = 0; i < array.length; ++i) {
                p.write((int)array[i]);
            }
            p.newLine();
            p.flush();
            p.pOlnI(block_body3);
            p.pln(block_body4);
            p.pOln(block_body5);
            p.pOln(block_body6);
            p.pOln(block_end);
            p.flush();
        }
    }

    private void writeCheckMustUnderstandInStub(IndentingWriter p) throws IOException {
        p.pln("// prepare message for check");
        p.pln("secPgUtil.prepareMessageForMUCheck(state.getResponse().getMessage());");
        p.pln();
        p.pln("com.sun.xml.rpc.client.HandlerChainImpl handlerChain = (com.sun.xml.rpc.client.HandlerChainImpl) state.getHandlerChain();");
        p.plnI("if (handlerChain != null && !handlerChain.isEmpty()) {");
        p.pln("boolean allUnderstood = handlerChain.checkMustUnderstand(state.getMessageContext());");
        p.plnI("if (allUnderstood == false) {");
        p.pln("throw new javax.xml.rpc.soap.SOAPFaultException(com.sun.xml.rpc.encoding.soap.SOAPConstants.FAULT_CODE_MUST_UNDERSTAND,\"SOAP must understand error\",_getActor(),null);");
        p.pOln("}");
        p.pOln("}");
        p.pln();
        p.pln("// restore message after check");
        p.pln("secPgUtil.restoreMessageAfterMUCheck(state.getResponse().getMessage());");
        p.flush();
    }

    private void writeCheckMustUnderstandInTie(IndentingWriter p) throws IOException {
        p.pln("// prepare message for check");
        p.pln("secPgUtil.prepareMessageForMUCheck(state.getRequest().getMessage());");
        p.pln();
        p.pln("com.sun.xml.rpc.client.HandlerChainImpl handlerChain = getHandlerChain();");
        p.plnI("if (handlerChain != null && !handlerChain.isEmpty()) {");
        p.pln("boolean allUnderstood = handlerChain.checkMustUnderstand(state.getMessageContext());");
        p.plnI("if (allUnderstood == false) {");
        p.pln("com.sun.xml.rpc.soap.message.SOAPFaultInfo fault = new com.sun.xml.rpc.soap.message.SOAPFaultInfo(com.sun.xml.rpc.encoding.soap.SOAPConstants.FAULT_CODE_MUST_UNDERSTAND,\"SOAP must understand error\", getActor());");
        p.pln("reportFault(fault, state);");
        p.pln("state.getRequest().setHeaderNotUnderstood(true);");
        p.pln("state.setHandlerFlag(StreamingHandlerState.CALL_NO_HANDLERS);");
        p.pln("return false;");
        p.pOln("}");
        p.pOln("}");
        p.pln();
        p.pln("// restore message after check");
        p.pln("secPgUtil.restoreMessageAfterMUCheck(state.getRequest().getMessage());");
        p.flush();
    }

    private String processString(String config) {
        return this.replaceOthers(this.replaceOthers(this.replaceNewLine(config), "\"", "\\\""), " ", " ");
    }

    private String replaceNewLine(String config) {
        return config.replace('\r', ' ').replace('\n', ' ');
    }

    private String replaceOthers(String config, String delim, String append) {
        StringTokenizer strTokenizer = new StringTokenizer(config, delim);
        StringBuffer sbuf = new StringBuffer();
        while (strTokenizer.hasMoreTokens()) {
            String tok = strTokenizer.nextToken();
            sbuf.append(tok);
            if (!strTokenizer.hasMoreTokens()) continue;
            sbuf.append(append);
        }
        return sbuf.toString();
    }

    private static class ErrorHandler
    extends DefaultHandler {
        PrintStream out;

        public ErrorHandler(PrintStream out) {
            this.out = out;
        }

        public void error(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
            throw e;
        }
    }
}

