/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl.client;

import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenProvider;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SignatureTargetCreator;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSCPlugin;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SCTokenProviderImpl
implements IssuedTokenProvider {
    private static final WSSCPlugin scp = WSSCFactory.newSCPlugin();
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private Map<String, IssuedTokenContext> issuedTokenContextMap = new HashMap<String, IssuedTokenContext>();
    private Map<String, SecurityContextTokenInfo> securityContextTokenMap = new HashMap<String, SecurityContextTokenInfo>();
    private boolean tokenExpired = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void issue(IssuedTokenContext ctx) throws WSTrustException {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
        if (this.issuedTokenContextMap.get(sctConfig.getTokenId()) != null) {
            IssuedTokenContext tmpCtx = null;
            try {
                tmpCtx = this.getSecurityContextToken(sctConfig.getTokenId(), sctConfig.checkTokenExpiry());
            }
            catch (WSSecureConversationException ex) {
                if (!sctConfig.isClientOutboundMessage()) throw new WSSecureConversationException((WSTrustException)((Object)ex));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "SecureConversationToken expired");
                }
                this.tokenExpired = true;
                this.renew(ctx);
                this.tokenExpired = false;
                tmpCtx = this.issuedTokenContextMap.get(sctConfig.getTokenId());
            }
            if (tmpCtx == null) throw new WSTrustException("IssuedTokenContext for Token id " + sctConfig.getTokenId() + " not found in the client cache.");
            ctx.setCreationTime(tmpCtx.getCreationTime());
            ctx.setExpirationTime(tmpCtx.getExpirationTime());
            ctx.setProofKey(tmpCtx.getProofKey());
            ctx.setSecurityToken(tmpCtx.getSecurityToken());
            ctx.setAttachedSecurityTokenReference(tmpCtx.getAttachedSecurityTokenReference());
            ctx.setUnAttachedSecurityTokenReference(tmpCtx.getUnAttachedSecurityTokenReference());
            if (tmpCtx.getSecurityToken() == null || ((SecurityContextToken)tmpCtx.getSecurityToken()).getInstance() == null) return;
            String sctInfoKey = ((SecurityContextToken)tmpCtx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)tmpCtx.getSecurityToken()).getInstance();
            ctx.setSecurityContextTokenInfo(this.getSecurityContextTokenInfo(sctInfoKey));
            return;
        }
        if (!sctConfig.isClientOutboundMessage()) {
            ctx.getSecurityPolicy().clear();
            return;
        } else {
            scp.process(ctx);
            String sctId = ((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString();
            sctConfig = new DefaultSCTokenConfiguration((DefaultSCTokenConfiguration)sctConfig, sctId);
            ctx.getSecurityPolicy().clear();
            ctx.getSecurityPolicy().add(sctConfig);
            this.addSecurityContextToken(((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString(), ctx);
        }
    }

    public void cancel(IssuedTokenContext ctx) throws WSTrustException {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
        if (this.issuedTokenContextMap.get(sctConfig.getTokenId()) != null) {
            scp.processCancellation(ctx);
            this.clearSessionCache(sctConfig.getTokenId(), ctx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renew(IssuedTokenContext ctx) throws WSTrustException {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
        MessagePolicy msgPolicy = (MessagePolicy)sctConfig.getOtherOptions().get("MessagePolicy");
        if (this.issuedTokenContextMap.get(sctConfig.getTokenId()) != null) {
            ctx = this.issuedTokenContextMap.get(sctConfig.getTokenId());
            SCTokenConfiguration origSCTConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
            if (!this.tokenExpired || !origSCTConfig.isRenewExpiredSCT()) throw new WSSecureConversationException("SecureConversation session for session Id:" + sctConfig.getTokenId() + "has expired.");
            scp.processRenew(ctx);
            String sctInfoKey = ((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)ctx.getSecurityToken()).getInstance();
            this.addSecurityContextTokenInfo(sctInfoKey, ctx.getSecurityContextTokenInfo());
            return;
        }
        if (msgPolicy == null) return;
        try {
            if (sctConfig.addRenewPolicy()) {
                this.appendEndorsingSCTRenewPolicy(msgPolicy);
                return;
            } else {
                this.deleteRenewPolicy(msgPolicy);
            }
            return;
        }
        catch (PolicyGenerationException e) {
            throw new WSTrustException(e.getMessage());
        }
    }

    public void validate(IssuedTokenContext ctx) throws WSTrustException {
    }

    private void addSecurityContextToken(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
    }

    private void addSecurityContextTokenInfo(String key, SecurityContextTokenInfo sctInfo) {
        this.securityContextTokenMap.put(key, sctInfo);
    }

    private void clearSessionCache(String sctId, IssuedTokenContext ctx) {
        this.securityContextTokenMap.remove(sctId + "_" + ((SecurityContextToken)ctx.getSecurityToken()).getInstance());
        this.issuedTokenContextMap.remove(sctId);
    }

    private IssuedTokenContext getSecurityContextToken(String key, boolean expiryCheck) throws WSSecureConversationException {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx != null && expiryCheck) {
            SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
            String maxClockSkew = (String)sctConfig.getOtherOptions().get("maxClockSkew");
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            if (maxClockSkew != null) {
                currentTime -= Long.parseLong(maxClockSkew);
            }
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WSSecureConversationException("SecureConversation session for session Id: " + key + " has expired.");
            }
        }
        return ctx;
    }

    private SecurityContextTokenInfo getSecurityContextTokenInfo(String key) {
        SecurityContextTokenInfo ctx = this.securityContextTokenMap.get(key);
        return ctx;
    }

    private void appendEndorsingSCTRenewPolicy(MessagePolicy policy) throws PolicyGenerationException {
        SignaturePolicy sp = scp.getRenewSignaturePolicy();
        SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
        ArrayList list = policy.getPrimaryPolicies();
        Iterator i = list.iterator();
        boolean addedSigTarget = false;
        while (i.hasNext()) {
            SecurityPolicy primaryPolicy = (SecurityPolicy)i.next();
            if (!PolicyTypeUtil.signaturePolicy(primaryPolicy)) continue;
            SignaturePolicy sigPolicy = (SignaturePolicy)primaryPolicy;
            IntegrityAssertionProcessor iAP = new IntegrityAssertionProcessor(scp.getAlgorithmSuite(), true);
            SignatureTargetCreator stc = iAP.getTargetCreator();
            SignatureTarget sigTarget = stc.newURISignatureTarget(sigPolicy.getUUID());
            SecurityPolicyUtil.setName(sigTarget, sigPolicy);
            spFB.addTargetBinding(sigTarget);
            spFB.isEndorsingSignature(true);
            addedSigTarget = true;
            break;
        }
        if (!addedSigTarget) {
            ArrayList sList = policy.getSecondaryPolicies();
            for (SecurityPolicy secPolicy : sList) {
                if (!PolicyTypeUtil.timestampPolicy(secPolicy)) continue;
                TimestampPolicy tsPolicy = (TimestampPolicy)secPolicy;
                IntegrityAssertionProcessor iAP = new IntegrityAssertionProcessor(scp.getAlgorithmSuite(), true);
                SignatureTargetCreator stc = iAP.getTargetCreator();
                SignatureTarget sigTarget = stc.newURISignatureTarget(tsPolicy.getUUID());
                SecurityPolicyUtil.setName(sigTarget, tsPolicy);
                spFB.addTargetBinding(sigTarget);
                spFB.isEndorsingSignature(true);
                addedSigTarget = true;
                break;
            }
        }
        if (addedSigTarget) {
            policy.append(sp);
        }
    }

    private void deleteRenewPolicy(MessagePolicy policy) {
        ArrayList list = policy.getPrimaryPolicies();
        for (SecurityPolicy primaryPolicy : list) {
            SignaturePolicy sigPolicy;
            if (!PolicyTypeUtil.signaturePolicy(primaryPolicy) || !(sigPolicy = (SignaturePolicy)primaryPolicy).getUUID().equals("_99")) continue;
            policy.remove(sigPolicy);
            break;
        }
    }
}

