/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.KeyIdentifierSPI;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.misc.Base64;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;

public class X509SubjectKeyIdentifier
extends KeyIdentifier {
    private String encodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private String valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    private X509Certificate cert = null;

    public X509SubjectKeyIdentifier(Document doc) throws XWSSecurityException {
        super(doc);
        this.setAttribute("EncodingType", this.encodingType);
        this.setAttribute("ValueType", this.valueType);
    }

    public X509SubjectKeyIdentifier(SOAPElement element) throws XWSSecurityException {
        super(element);
    }

    public byte[] getDecodedBase64EncodedValue() throws XWSSecurityException {
        try {
            return Base64.decode(this.getReferenceValue());
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", new Object[]{e.getMessage()});
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) throws XWSSecurityException {
        KeyIdentifierSPI spi = KeyIdentifierSPI.getInstance();
        if (spi != null) {
            try {
                return spi.getSubjectKeyIdentifier(cert);
            }
            catch (KeyIdentifierSPI.KeyIdentifierSPIException ex) {
                throw new XWSSecurityException((Throwable)ex);
            }
        }
        throw new XWSSecurityException("Could not locate SPI class for KeyIdentifierSPI");
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }
}

