/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.commons.ScheduledTaskManager;
import com.sun.xml.ws.rx.rm.runtime.DestinationMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.SourceMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RuntimeContext {
    public final RmConfiguration configuration;
    public final AddressingVersion addressingVersion;
    public final SOAPVersion soapVersion;
    public final RmRuntimeVersion rmVersion;
    private volatile SequenceManager sequenceManager;
    public final Communicator communicator;
    public final SuspendedFiberStorage suspendedFiberStorage;
    public final WsrmProtocolHandler protocolHandler;
    public final ScheduledTaskManager scheduledTaskManager;
    final SourceMessageHandler sourceMessageHandler;
    final DestinationMessageHandler destinationMessageHandler;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static Builder builder(@NotNull RmConfiguration configuration, @NotNull Communicator communicator) {
        return new Builder(configuration, communicator);
    }

    private RuntimeContext(RmConfiguration configuration, SequenceManager sequenceManager, Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, ScheduledTaskManager scheduledTaskManager, SourceMessageHandler srcMsgHandler, DestinationMessageHandler dstMsgHandler) {
        this.configuration = configuration;
        this.sequenceManager = sequenceManager;
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.scheduledTaskManager = scheduledTaskManager;
        this.sourceMessageHandler = srcMsgHandler;
        this.destinationMessageHandler = dstMsgHandler;
        this.addressingVersion = configuration.getAddressingVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.rmVersion = configuration.getRuntimeVersion();
        this.protocolHandler = WsrmProtocolHandler.getInstance(configuration, communicator, this);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduledTaskManager.shutdown();
            this.communicator.close();
            if (this.sequenceManager != null) {
                SequenceManagerFactory.INSTANCE.dispose(this.sequenceManager, this.configuration);
            }
        }
    }

    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getSequence(sequenceId);
    }

    public Sequence getOutboundSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getSequence(sequenceId);
    }

    public Sequence getBoundSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getBoundSequence(sequenceId);
    }

    public String getBoundSequenceId(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        Sequence boundSequence = this.sequenceManager.getBoundSequence(sequenceId);
        return boundSequence != null ? boundSequence.getId() : null;
    }

    public SequenceManager sequenceManager() {
        assert (this.sequenceManager != null);
        return this.sequenceManager;
    }

    public void setSequenceManager(@NotNull SequenceManager newValue) {
        assert (newValue != null);
        this.sequenceManager = newValue;
        this.sourceMessageHandler.setSequenceManager(newValue);
        this.destinationMessageHandler.setSequenceManager(newValue);
    }

    public static final class Builder {
        @NotNull
        private final RmConfiguration configuration;
        @NotNull
        private final Communicator communicator;
        @Nullable
        private SequenceManager sequenceManager;
        @Nullable
        private SourceMessageHandler sourceMessageHandler;
        @Nullable
        private DestinationMessageHandler destinationMessageHandler;

        public Builder(@NotNull RmConfiguration configuration, @NotNull Communicator communicator) {
            assert (configuration != null);
            assert (communicator != null);
            this.configuration = configuration;
            this.communicator = communicator;
            this.sourceMessageHandler = new SourceMessageHandler(null);
            this.destinationMessageHandler = new DestinationMessageHandler(null);
        }

        public Builder sequenceManager(SequenceManager sequenceManager) {
            this.sequenceManager = sequenceManager;
            this.sourceMessageHandler.setSequenceManager(sequenceManager);
            this.destinationMessageHandler.setSequenceManager(sequenceManager);
            return this;
        }

        public RuntimeContext build() {
            return new RuntimeContext(this.configuration, this.sequenceManager, this.communicator, new SuspendedFiberStorage(), new ScheduledTaskManager("RM Runtime Context"), this.sourceMessageHandler, this.destinationMessageHandler);
        }
    }
}

