/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.server;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.server.WSDLRetriever;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public class MetadataServerPipe
extends AbstractFilterTubeImpl {
    private final WSDLRetriever wsdlRetriever;
    private final SOAPVersion soapVersion;
    private static final Logger logger = Logger.getLogger(MetadataServerPipe.class.getName());

    public MetadataServerPipe(WSEndpoint endpoint, Pipe next) {
        super(PipeAdapter.adapt((Pipe)next));
        this.wsdlRetriever = new WSDLRetriever(endpoint);
        this.soapVersion = endpoint.getBinding().getSOAPVersion();
    }

    protected MetadataServerPipe(MetadataServerPipe that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.soapVersion = that.soapVersion;
        this.wsdlRetriever = that.wsdlRetriever;
    }

    public MetadataServerPipe copy(TubeCloner cloner) {
        return new MetadataServerPipe(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        if (request.getMessage() == null || !request.getMessage().hasHeaders()) {
            return super.processRequest(request);
        }
        HeaderList headers = request.getMessage().getHeaders();
        String action = headers.getAction(AddressingVersion.W3C, this.soapVersion);
        AddressingVersion adVersion = AddressingVersion.W3C;
        if (action == null) {
            action = headers.getAction(AddressingVersion.MEMBER, this.soapVersion);
            adVersion = AddressingVersion.MEMBER;
        }
        if (action != null) {
            if (action.equals("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get")) {
                String toAddress = headers.getTo(adVersion, this.soapVersion);
                return this.doReturnWith(this.processGetRequest(request, toAddress, adVersion));
            }
            if (action.equals("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request")) {
                Message faultMessage = Messages.create((String)"http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request", (AddressingVersion)adVersion, (SOAPVersion)this.soapVersion);
                return this.doReturnWith(request.createServerResponse(faultMessage, adVersion, this.soapVersion, adVersion.getDefaultFaultAction()));
            }
        }
        return super.processRequest(request);
    }

    private Packet processGetRequest(Packet request, String address, AddressingVersion adVersion) {
        try {
            MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
            XMLStreamWriter writer = buffer.createFromXMLStreamWriter();
            this.writeStartEnvelope(writer, adVersion);
            this.wsdlRetriever.addDocuments(writer, request, address);
            writer.writeEndDocument();
            writer.flush();
            Message responseMessage = Messages.create((XMLStreamBuffer)buffer);
            Packet response = request.createServerResponse(responseMessage, adVersion, this.soapVersion, "http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse");
            return response;
        }
        catch (XMLStreamException streamE) {
            String exceptionMessage = MessagesMessages.MEX_0001_RESPONSE_WRITING_FAILURE(address);
            logger.log(Level.SEVERE, exceptionMessage, streamE);
            throw new WebServiceException(exceptionMessage, (Throwable)streamE);
        }
    }

    private void writeStartEnvelope(XMLStreamWriter writer, AddressingVersion adVersion) throws XMLStreamException {
        String soapPrefix = "soapenv";
        writer.writeStartDocument();
        writer.writeStartElement("soapenv", "Envelope", this.soapVersion.nsUri);
        writer.writeNamespace("soapenv", this.soapVersion.nsUri);
        writer.writeNamespace("wsa", adVersion.nsUri);
        writer.writeNamespace("mex", "http://schemas.xmlsoap.org/ws/2004/09/mex");
        writer.writeStartElement("soapenv", "Body", this.soapVersion.nsUri);
        writer.writeStartElement("mex", "Metadata", "http://schemas.xmlsoap.org/ws/2004/09/mex");
    }
}

