/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import com.sun.xml.ws.tx.at.tube.WSATClient;
import com.sun.xml.ws.tx.coord.common.WSATCoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.WSCBuilderFactory;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientHelper
implements WSATClient {
    @Override
    public List<Header> doHandleRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        List<Header> addedHeaders = this.processTransactionalRequest(transactionalAttribute, map);
        return addedHeaders;
    }

    @Override
    public boolean doHandleResponse(Map<String, Object> map) {
        return this.resumeAndClearXidTxMap(map);
    }

    @Override
    public void doHandleException(Map<String, Object> map) {
        this.resumeAndClearXidTxMap(map);
    }

    private boolean resumeAndClearXidTxMap(Map<String, Object> map) {
        Transaction transaction;
        Xid xid = this.getWSATXidFromMap(map);
        if (xid != null) {
            WSATHelper.getInstance().removeFromXidToTransactionMap(xid);
        }
        return (transaction = this.getWSATTransactionFromMap(map)) == null || this.resume(transaction);
    }

    private Transaction getWSATTransactionFromMap(Map map) {
        Transaction transaction = (Transaction)map.get("wsat.transaction");
        return transaction;
    }

    private Xid getWSATXidFromMap(Map map) {
        Xid xid = (Xid)map.get("wsat.transaction.xid");
        return xid;
    }

    private boolean resume(Transaction transaction) {
        try {
            TransactionManagerImpl.getInstance().getTransactionManager().resume(transaction);
            return true;
        }
        catch (InvalidTransactionException e) {
            if (WSATHelper.isDebugEnabled()) {
                try {
                    transaction.setRollbackOnly();
                }
                catch (IllegalStateException ex) {
                    Logger.getLogger(WSATClientHelper.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
                catch (SystemException ex) {
                    Logger.getLogger(WSATClientHelper.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            return false;
        }
        catch (SystemException e) {
            try {
                transaction.setRollbackOnly();
                return false;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger(WSATClientHelper.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (SystemException ex) {
                Logger.getLogger(WSATClientHelper.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
    }

    private List<Header> processTransactionalRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        ArrayList<Header> headers = new ArrayList<Header>();
        String txId = null;
        String s = UUID.randomUUID().toString().replace("urn:", "").replaceAll("uuid:", "").trim();
        XidImpl xid = new XidImpl(1234, new String("" + System.currentTimeMillis()).getBytes(), new byte[0]);
        txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        long ttl = 0L;
        try {
            ttl = TransactionImportManager.getInstance().getTransactionRemainingTimeout();
        }
        catch (SystemException ex) {
            Logger.getLogger(WSATClientHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        WSCBuilderFactory builderFactory = WSCBuilderFactory.newInstance(transactionalAttribute.getVersion());
        WSATCoordinationContextBuilder builder = builderFactory.newWSATCoordinationContextBuilder();
        CoordinationContextIF cc = builder.txId(txId).expires(ttl).soapVersion(transactionalAttribute.getSoapVersion()).mustUnderstand(true).build();
        Header coordinationHeader = Headers.create((JAXBRIContext)cc.getJAXBRIContext(), cc.getDelegate());
        headers.add(coordinationHeader);
        Transaction suspendedTransaction = this.suspend(map);
        map.put("wsat.transaction.xid", xid);
        WSATHelper.getInstance().putToXidToTransactionMap(xid, suspendedTransaction);
        return headers;
    }

    private Transaction suspend(Map<String, Object> map) {
        Transaction suspendedTransaction = null;
        try {
            suspendedTransaction = TransactionManagerImpl.getInstance().getTransactionManager().suspend();
            map.put("wsat.transaction", suspendedTransaction);
        }
        catch (SystemException e) {
            return null;
        }
        return suspendedTransaction;
    }
}

