/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.dev;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.AbstractMOMRegistrationAware;
import com.sun.xml.ws.commons.MOMRegistrationAware;
import com.sun.xml.ws.commons.WSEndpointCollectionBasedMOMListener;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManagerImpl;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Session manager used by RM and SC")
@AMXMetadata(type="WSRMSCSessionManager")
public abstract class SessionManager
extends AbstractMOMRegistrationAware {
    private static final Logger LOGGER = Logger.getLogger(SessionManager.class);
    private static Properties config = null;
    private static final Object LOCK = new Object();
    private static final Map<WSEndpoint, SessionManager> SESSION_MANAGERS = new HashMap<WSEndpoint, SessionManager>();
    private static final WSEndpointCollectionBasedMOMListener listener = new WSEndpointCollectionBasedMOMListener(LOCK, "RM_SC_SessionManager", SESSION_MANAGERS);
    public static final String TIMEOUT_INTERVAL = "session-timeout";
    public static final String SESSION_THRESHOLD = "session-threshold";

    public static Properties getConfig() {
        return config;
    }

    public static void setConfig(Properties aConfig) {
        config = aConfig;
    }

    public abstract Session getSession(String var1);

    @ManagedAttribute
    @Description(value="The set of valid Session keys")
    public abstract Set<String> keys();

    @ManagedAttribute
    @Description(value="The collection of valid Sessions")
    protected abstract Collection<Session> sessions();

    public abstract void terminateSession(String var1);

    public abstract Session createSession(String var1, Class var2);

    public abstract Session createSession(String var1, Object var2);

    public abstract Session createSession(String var1, SecurityContextTokenInfo var2);

    public abstract Session createSession(String var1);

    public abstract void saveSession(String var1);

    public abstract IssuedTokenContext getSecurityContext(String var1, boolean var2);

    public abstract void addSecurityContext(String var1, IssuedTokenContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSessionManager(WSEndpoint endpoint) {
        Object object = LOCK;
        synchronized (object) {
            try {
                LOGGER.entering();
                SessionManager o = SESSION_MANAGERS.remove(endpoint);
                LOGGER.config(String.format("removeSessionManager(%s): %s", new Object[]{endpoint, o}));
                SessionManager sessionManager = o;
                if (sessionManager != null && sessionManager.isRegisteredAtMOM()) {
                    listener.unregisterFromMOM((MOMRegistrationAware)sessionManager, endpoint);
                }
            }
            finally {
                LOGGER.exiting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionManager getSessionManager(WSEndpoint endpoint, boolean isSC, Properties props) {
        Object object = LOCK;
        synchronized (object) {
            SessionManager sessionManager;
            try {
                LOGGER.entering();
                SessionManager sm = SESSION_MANAGERS.get(endpoint);
                if (sm == null) {
                    ServiceFinder finder = ServiceFinder.find(SessionManager.class);
                    sm = finder != null && ((SessionManager[])finder.toArray()).length > 0 ? ((SessionManager[])finder.toArray())[0] : new SessionManagerImpl(endpoint, isSC, props);
                    SESSION_MANAGERS.put(endpoint, sm);
                    if (listener.canRegisterAtMOM()) {
                        listener.registerAtMOM((MOMRegistrationAware)sm, endpoint);
                    }
                    LOGGER.config(String.format("getSessionManager(%s): created: %s", new Object[]{endpoint, sm}));
                } else {
                    LOGGER.config(String.format("getSessionManager(%s): found existing: %s", new Object[]{endpoint, sm}));
                }
                sessionManager = sm;
            }
            catch (Throwable throwable) {
                LOGGER.exiting();
                throw throwable;
            }
            LOGGER.exiting();
            return sessionManager;
        }
    }

    public static SessionManager getSessionManager(WSEndpoint endpoint, Properties props) {
        return SessionManager.getSessionManager(endpoint, false, props);
    }

    static {
        listener.initialize();
    }
}

