/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.test.model.EndpointReader;
import com.sun.xml.ws.test.model.TestDescriptor;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.model.WSDL;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestService {
    @NotNull
    public final String name;
    @NotNull
    public final File baseDir;
    @Nullable
    public final List<WSDL> wsdl;
    @NotNull
    public final List<File> customizations = new ArrayList<File>();
    @NotNull
    public final Set<TestEndpoint> endpoints = new LinkedHashSet<TestEndpoint>();
    public final TestDescriptor parent;
    public boolean isSTS;

    public TestService(TestDescriptor parent, String name, File baseDir, List<WSDL> wsdl, boolean sts, @Nullable String explicitServiceClassName) throws IOException {
        this.parent = parent;
        this.name = name;
        this.wsdl = wsdl;
        this.baseDir = baseDir;
        this.isSTS = sts;
        if (explicitServiceClassName == null) {
            this.findEndpoints(baseDir);
        } else {
            String shortName = explicitServiceClassName.substring(explicitServiceClassName.lastIndexOf(46) + 1);
            this.endpoints.add(new TestEndpoint(shortName, explicitServiceClassName, null, false));
        }
    }

    public String getAbsolutePath(String relativePath) {
        return this.baseDir.getAbsolutePath() + File.separator + relativePath;
    }

    public TestEndpoint getEndpointByImpl(String implClassFullName) {
        for (TestEndpoint ep : this.endpoints) {
            if (!ep.className.equals(implClassFullName)) continue;
            return ep;
        }
        throw new Error("No TestEndpoint object recorded for " + implClassFullName);
    }

    public String getGlobalUniqueName() {
        if (this.name.length() == 0) {
            return this.parent.name;
        }
        return this.parent.name + '.' + this.name;
    }

    private void findEndpoints(File dir) throws IOException {
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File child) {
                return child.isDirectory() && !child.getName().equals("work");
            }
        });
        Arrays.sort(dirs, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f2.compareTo(f1);
            }
        });
        for (File subdir : dirs) {
            this.findEndpoints(subdir);
        }
        File[] javas = dir.listFiles(new FileFilter(){

            public boolean accept(File child) {
                return child.getName().endsWith(".java");
            }
        });
        if (javas.length > 0) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                try {
                    Class<?> compilerClass = Class.forName("com.sun.tools.javac.api.JavacTool");
                    Constructor<?> constructor = compilerClass.getConstructor(new Class[0]);
                    compiler = (JavaCompiler)constructor.newInstance(new Object[0]);
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, (Iterable<String>)new ArrayList<String>(){
                {
                    this.add("-proc:only");
                }
            }, null, fileManager.getJavaFileObjects(javas));
            EndpointReader r = new EndpointReader();
            task.setProcessors(Collections.singleton(r));
            task.call();
            this.endpoints.addAll(r.getTestEndpoints());
        }
    }

    public String toString() {
        return this.name + " of " + this.parent.toString();
    }

    public File[] getHandlerConfiguration() {
        return this.baseDir.listFiles(new HandlersFilter());
    }

    public File getConfiguredFile(String filename) {
        return this.first(this.baseDir.listFiles(new NameFilter(filename)));
    }

    private File first(File[] files) {
        return files == null || files.length == 0 ? null : files[0];
    }

    class NameFilter
    implements FilenameFilter {
        String filename;

        NameFilter(String filename) {
            this.filename = filename;
        }

        public boolean accept(File dir, String name) {
            return name.equals(this.filename);
        }
    }

    class HandlersFilter
    implements FilenameFilter {
        HandlersFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("handlers.xml");
        }
    }
}

