/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.client;

import bsh.Interpreter;
import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.model.TestClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Assert;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBaseClass
extends Assert {
    private final DeploymentContext context;
    private final TestClient client;
    private final Interpreter engine;

    public ScriptBaseClass(DeploymentContext context, Interpreter engine, TestClient client) {
        this.context = context;
        this.client = client;
        this.engine = engine;
    }

    public File resource(@NotNull String name) {
        return new File(this.context.getResources(), name);
    }

    public Source makeSaxSource(String msg) {
        ByteArrayInputStream saxinputStream = new ByteArrayInputStream(msg.getBytes());
        return new SAXSource(new InputSource(saxinputStream));
    }

    public static Source makeStreamSource(String msg) {
        return new StreamSource(new ByteArrayInputStream(msg.getBytes()));
    }

    public static Collection<Source> makeMsgSource(String msg) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<Source> sourceList = new ArrayList<Source>();
        byte[] bytes = msg.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayInputStream saxinputStream = new ByteArrayInputStream(bytes);
        InputSource inputSource = new InputSource(saxinputStream);
        ByteArrayInputStream sinputStream = new ByteArrayInputStream(bytes);
        DOMSource domSource = new DOMSource(ScriptBaseClass.createDOMNode(inputStream));
        sourceList.add(domSource);
        SAXSource saxSource = new SAXSource(inputSource);
        sourceList.add(saxSource);
        StreamSource streamSource = new StreamSource(sinputStream);
        sourceList.add(streamSource);
        return sourceList;
    }

    public static Source makeDOMSource(String msg) throws IOException, ParserConfigurationException, SAXException {
        byte[] bytes = msg.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new DOMSource(ScriptBaseClass.createDOMNode(inputStream));
    }

    public static Node createDOMNode(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(inputStream);
    }

    public String sourceToXMLString(Source result) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(out);
        transformer.transform(result, streamResult);
        return streamResult.getOutputStream().toString();
    }
}

