/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=1010)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRED)
public class TransactionalInterceptorRequired
extends TransactionalInterceptorBase {
    private static Logger _logger = LogDomains.getLogger(TransactionalInterceptorRequired.class, (String)"javax.enterprise.resource.jta");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.info("In REQUIRED TransactionalInterceptor");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            boolean isTransactionStarted = false;
            if (this.getTransactionManager().getTransaction() == null) {
                _logger.info("Managed bean with Transactional annotation and TxType of REQUIRED called outside a transaction context.  Beginning a transaction...");
                try {
                    this.getTransactionManager().begin();
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during begin " + exception;
                    _logger.info(messageString);
                    throw new TransactionalException(messageString, (Throwable)exception);
                }
                isTransactionStarted = true;
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (isTransactionStarted) {
                    try {
                        this.getTransactionManager().commit();
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during commit " + exception;
                        _logger.info(messageString);
                        throw new TransactionalException(messageString, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

