/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class TransactionalInterceptorBase
implements Serializable {
    private static TransactionManager testTransactionManager;
    private static volatile TransactionManager transactionManager;
    private transient TransactionOperationsManager preexistingTransactionOperationsManager;
    private static final TransactionOperationsManager transactionalTransactionOperationsManagerTransactionMethodsAllowed;
    private static final TransactionOperationsManager transactionalTransactionOperationsManagerTransactionMethodsNotAllowed;
    private static Logger _logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (testTransactionManager != null) {
            return testTransactionManager;
        }
        if (transactionManager == null) {
            try {
                Class<TransactionalInterceptorBase> clazz = TransactionalInterceptorBase.class;
                synchronized (TransactionalInterceptorBase.class) {
                    if (transactionManager == null) {
                        transactionManager = (TransactionManager)new InitialContext().lookup("java:appserver/TransactionManager");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (NamingException e) {
                _logger.severe("Encountered NamingException while attempting to acquire transaction manager for Transactional annotation interceptors " + e);
                throw new RuntimeException("Unable to obtain TransactionManager for Transactional Interceptor", e);
            }
        }
        {
            return transactionManager;
        }
    }

    static void setTestTransactionManager(TransactionManager transactionManager) {
        testTransactionManager = transactionManager;
    }

    boolean isLifeCycleMethod(InvocationContext ctx) {
        return ctx.getMethod().getAnnotation(PostConstruct.class) != null || ctx.getMethod().getAnnotation(PreDestroy.class) != null;
    }

    public Object proceed(InvocationContext ctx) throws Exception {
        Object object;
        Transactional transactionalAnnotation = ctx.getMethod().getAnnotation(Transactional.class);
        Class[] rollbackOn = null;
        Class[] dontRollbackOn = null;
        if (transactionalAnnotation != null) {
            rollbackOn = transactionalAnnotation.rollbackOn();
            dontRollbackOn = transactionalAnnotation.dontRollbackOn();
        } else {
            Class<?> targetClass = ctx.getTarget().getClass();
            transactionalAnnotation = targetClass.getAnnotation(Transactional.class);
            if (transactionalAnnotation != null) {
                rollbackOn = transactionalAnnotation.rollbackOn();
                dontRollbackOn = transactionalAnnotation.dontRollbackOn();
            }
        }
        try {
            object = ctx.proceed();
        }
        catch (RuntimeException runtimeException) {
            if (dontRollbackOn != null) {
                for (Class aDontRollbackOn : dontRollbackOn) {
                    if (!aDontRollbackOn.equals(runtimeException.getClass())) continue;
                    throw runtimeException;
                }
                this.markRollbackIfActiveTransaction();
            } else {
                this.markRollbackIfActiveTransaction();
            }
            throw runtimeException;
        }
        catch (Exception checkException) {
            if (rollbackOn != null) {
                for (Class aRollbackOn : rollbackOn) {
                    if (!aRollbackOn.equals(checkException.getClass())) continue;
                    this.markRollbackIfActiveTransaction();
                }
            }
            throw checkException;
        }
        return object;
    }

    private void markRollbackIfActiveTransaction() throws SystemException {
        Transaction transaction = this.getTransactionManager().getTransaction();
        if (transaction != null) {
            _logger.info("About to setRollbackOnly from @Transactional interceptor on transaction:" + transaction);
            this.getTransactionManager().setRollbackOnly();
        }
    }

    void setTransactionalTransactionOperationsManger(boolean userTransactionMethodsAllowed) {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            _logger.warning("No ComponentInvocation present for @Transactional annotation processing.  Restriction on use of UserTransaction will not be enforced");
            return;
        }
        this.preexistingTransactionOperationsManager = (TransactionOperationsManager)currentInvocation.getTransactionOperationsManager();
        currentInvocation.setTransactionOperationsManager((Object)(userTransactionMethodsAllowed ? transactionalTransactionOperationsManagerTransactionMethodsAllowed : transactionalTransactionOperationsManagerTransactionMethodsNotAllowed));
    }

    void resetTransactionOperationsManager() {
        if (testTransactionManager != null) {
            return;
        }
        ComponentInvocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation == null) {
            System.out.println("TransactionalInterceptorBase.markThreadAsTransactional currentInvocation==null");
            return;
        }
        currentInvocation.setTransactionOperationsManager((Object)this.preexistingTransactionOperationsManager);
    }

    ComponentInvocation getCurrentInvocation() {
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        InvocationManager invocationManager = serviceLocator == null ? null : (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        return invocationManager == null ? null : invocationManager.getCurrentInvocation();
    }

    static {
        transactionalTransactionOperationsManagerTransactionMethodsAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsAllowed();
        transactionalTransactionOperationsManagerTransactionMethodsNotAllowed = new TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed();
        _logger = LogDomains.getLogger(TransactionalInterceptorBase.class, (String)"javax.enterprise.resource.jta");
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsNotAllowed() {
        }

        public boolean userTransactionMethodsAllowed() {
            return false;
        }

        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        public void doAfterUtxBegin() {
        }
    }

    private static final class TransactionalTransactionOperationsManagerTransactionMethodsAllowed
    implements TransactionOperationsManager {
        private TransactionalTransactionOperationsManagerTransactionMethodsAllowed() {
        }

        public boolean userTransactionMethodsAllowed() {
            return true;
        }

        public void userTransactionLookupAllowed() throws NameNotFoundException {
        }

        public void doAfterUtxBegin() {
        }
    }
}

