/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.glassfish.weld.ejb.SessionObjectReferenceImpl;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;

public class EjbServicesImpl
implements EjbServices {
    private ServiceLocator services;
    private Logger logger = Logger.getLogger(EjbServicesImpl.class.getName());

    public EjbServicesImpl(ServiceLocator h) {
        this.services = h;
    }

    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        SessionObjectReferenceImpl sessionObj = null;
        String globalJndiName = this.getDefaultGlobalJndiName(ejbDescriptor);
        if (globalJndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Object ejbRef = ic.lookup(globalJndiName);
                EjbContainerServices containerServices = (EjbContainerServices)this.services.getService(EjbContainerServices.class, new Annotation[0]);
                sessionObj = new SessionObjectReferenceImpl(containerServices, ejbRef);
            }
            catch (NamingException ne) {
                throw new IllegalStateException("Error resolving session object reference for ejb name " + ejbDescriptor.getBeanClass() + " and jndi name " + globalJndiName, ne);
            }
        } else {
            throw new IllegalArgumentException("Not enough type information to resolve ejb for  ejb name " + ejbDescriptor.getBeanClass());
        }
        return sessionObj;
    }

    private String getDefaultGlobalJndiName(EjbDescriptor<?> ejbDesc) {
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)((EjbDescriptorImpl)ejbDesc).getEjbDescriptor();
        String clientView = null;
        if (sessionDesc.isLocalBean()) {
            clientView = sessionDesc.getEjbClassName();
        } else if (sessionDesc.getLocalBusinessClassNames().size() >= 1) {
            clientView = (String)sessionDesc.getLocalBusinessClassNames().iterator().next();
        } else if (sessionDesc.getRemoteBusinessClassNames().size() >= 1) {
            clientView = (String)sessionDesc.getRemoteBusinessClassNames().iterator().next();
        }
        return clientView != null ? sessionDesc.getPortableJndiName(clientView) : null;
    }

    public void registerInterceptors(EjbDescriptor<?> ejbDesc, InterceptorBindings interceptorBindings) {
        if (ejbDesc instanceof InternalEjbDescriptor) {
            ejbDesc = ((InternalEjbDescriptor)ejbDesc).delegate();
        }
        com.sun.enterprise.deployment.EjbDescriptor glassfishEjbDesc = ((EjbDescriptorImpl)ejbDesc).getEjbDescriptor();
        for (Interceptor next : interceptorBindings.getAllInterceptors()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "trying to register:" + next);
            }
            if (glassfishEjbDesc.hasInterceptorClass(next.getBeanClass().getName())) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Adding interceptor: " + next.getBeanClass().getName() + " for EJB:" + glassfishEjbDesc.getEjbClassName());
            }
            EjbInterceptor ejbInt = this.makeEjbInterceptor(next, glassfishEjbDesc.getEjbBundleDescriptor());
            glassfishEjbDesc.addInterceptorClass(ejbInt);
        }
        List<EjbInterceptor> postConstructChain = this.makeInterceptorChain(InterceptionType.POST_CONSTRUCT, interceptorBindings.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT), glassfishEjbDesc);
        glassfishEjbDesc.appendToInterceptorChain(postConstructChain);
        List<EjbInterceptor> preDestroyChain = this.makeInterceptorChain(InterceptionType.PRE_DESTROY, interceptorBindings.getLifecycleInterceptors(InterceptionType.PRE_DESTROY), glassfishEjbDesc);
        glassfishEjbDesc.appendToInterceptorChain(preDestroyChain);
        List<EjbInterceptor> prePassivateChain = this.makeInterceptorChain(InterceptionType.PRE_PASSIVATE, interceptorBindings.getLifecycleInterceptors(InterceptionType.PRE_PASSIVATE), glassfishEjbDesc);
        glassfishEjbDesc.appendToInterceptorChain(prePassivateChain);
        List<EjbInterceptor> postActivateChain = this.makeInterceptorChain(InterceptionType.POST_ACTIVATE, interceptorBindings.getLifecycleInterceptors(InterceptionType.POST_ACTIVATE), glassfishEjbDesc);
        glassfishEjbDesc.appendToInterceptorChain(postActivateChain);
        Class<?> ejbBeanClass = null;
        try {
            ClassLoader cl = glassfishEjbDesc.getEjbBundleDescriptor().getClassLoader();
            ejbBeanClass = cl.loadClass(glassfishEjbDesc.getEjbClassName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Cannot load bean class " + glassfishEjbDesc.getEjbClassName(), cnfe);
        }
        for (Method m : ejbBeanClass.getMethods()) {
            List<EjbInterceptor> aroundInvokeChain = this.makeInterceptorChain(InterceptionType.AROUND_INVOKE, interceptorBindings.getMethodInterceptors(InterceptionType.AROUND_INVOKE, m), glassfishEjbDesc);
            glassfishEjbDesc.addMethodLevelChain(aroundInvokeChain, m, true);
            List<EjbInterceptor> aroundTimeoutChain = this.makeInterceptorChain(InterceptionType.AROUND_TIMEOUT, interceptorBindings.getMethodInterceptors(InterceptionType.AROUND_TIMEOUT, m), glassfishEjbDesc);
            glassfishEjbDesc.addMethodLevelChain(aroundTimeoutChain, m, false);
        }
    }

    private List<EjbInterceptor> makeInterceptorChain(InterceptionType interceptionType, List<Interceptor<?>> lifecycleList, com.sun.enterprise.deployment.EjbDescriptor ejbDesc) {
        LinkedList<EjbInterceptor> ejbInterceptorList = new LinkedList<EjbInterceptor>();
        if (lifecycleList == null) {
            return ejbInterceptorList;
        }
        for (Interceptor<?> next : lifecycleList) {
            EjbInterceptor ejbInt = this.makeEjbInterceptor(next, ejbDesc.getEjbBundleDescriptor());
            LifecycleCallbackDescriptor lifecycleDesc = new LifecycleCallbackDescriptor();
            lifecycleDesc.setLifecycleCallbackClass(next.getBeanClass().getName());
            lifecycleDesc.setLifecycleCallbackMethod(this.getInterceptorMethod(next.getBeanClass(), this.getInterceptorAnnotationType(interceptionType)));
            switch (interceptionType) {
                case POST_CONSTRUCT: {
                    ejbInt.addPostConstructDescriptor(lifecycleDesc);
                    break;
                }
                case PRE_DESTROY: {
                    ejbInt.addPreDestroyDescriptor(lifecycleDesc);
                    break;
                }
                case PRE_PASSIVATE: {
                    ejbInt.addPrePassivateDescriptor(lifecycleDesc);
                    break;
                }
                case POST_ACTIVATE: {
                    ejbInt.addPostActivateDescriptor(lifecycleDesc);
                    break;
                }
                case AROUND_INVOKE: {
                    ejbInt.addAroundInvokeDescriptor(lifecycleDesc);
                    break;
                }
                case AROUND_TIMEOUT: {
                    ejbInt.addAroundTimeoutDescriptor(lifecycleDesc);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid lifecycle interception type " + interceptionType);
                }
            }
            ejbInterceptorList.add(ejbInt);
        }
        return ejbInterceptorList;
    }

    private Class<?> getInterceptorAnnotationType(InterceptionType interceptionType) {
        switch (interceptionType) {
            case POST_CONSTRUCT: {
                return PostConstruct.class;
            }
            case PRE_DESTROY: {
                return PreDestroy.class;
            }
            case PRE_PASSIVATE: {
                return PrePassivate.class;
            }
            case POST_ACTIVATE: {
                return PostActivate.class;
            }
            case AROUND_INVOKE: {
                return AroundInvoke.class;
            }
            case AROUND_TIMEOUT: {
                return AroundTimeout.class;
            }
        }
        throw new IllegalArgumentException("Invalid interception type " + interceptionType);
    }

    private String getInterceptorMethod(Class interceptorClass, Class annotation) {
        for (Method next : interceptorClass.getDeclaredMethods()) {
            if (next.getAnnotation(annotation) == null) continue;
            return next.getName();
        }
        throw new IllegalStateException("Interceptor Class " + interceptorClass + " has no method annotated with " + annotation);
    }

    private EjbInterceptor makeEjbInterceptor(Interceptor<?> interceptor, EjbBundleDescriptor bundle) {
        EjbInterceptor ejbInt = new EjbInterceptor();
        ejbInt.setBundleDescriptor((BundleDescriptor)bundle);
        ejbInt.setInterceptorClassName(interceptor.getBeanClass().getName());
        ejbInt.setCDIInterceptor(true);
        return ejbInt;
    }

    public void cleanup() {
    }
}

