/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ResourceLoaderImpl;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.ProxyServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.glassfish.weld.services.ValidationServicesImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jvnet.hk2.annotations.Service;

@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private Logger _logger = LogDomains.getLogger(WeldDeployer.class, (String)"javax.enterprise.system.core");
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "org.glassfish.weld.WeldBootstrap";
    private static final String WELD_CONTEXT_LISTENER = "org.glassfish.weld.WeldContextListener";
    private static final String WELD_LISTENER = "org.jboss.weld.servlet.WeldListener";
    private static final String WELD_SHUTDOWN = "false";
    @Inject
    private Events events;
    @Inject
    private ServiceLocator services;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    private Map<Application, WeldBootstrap> appToBootstrap = new HashMap<Application, WeldBootstrap>();
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();
    private static final Class<?>[] NON_CONTEXT_CLASSES = new Class[]{Servlet.class, ServletContextListener.class, Filter.class, HttpSessionListener.class, ServletRequestListener.class};

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(EventListener.Event event) {
        if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                DeploymentImpl deploymentImpl = (DeploymentImpl)appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
                Collection archives = deploymentImpl.getBeanDeploymentArchives();
                for (BeanDeploymentArchive archive : archives) {
                    ResourceLoaderImpl loader = new ResourceLoaderImpl(((BeanDeploymentArchiveImpl)archive).getModuleClassLoaderForBDA());
                    archive.getServices().add(ResourceLoader.class, (org.jboss.weld.bootstrap.api.Service)loader);
                }
                deploymentImpl.buildDeploymentGraph();
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine(deploymentImpl.toString());
                }
                ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
                final String fAppName = appInfo.getName();
                this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                    public String getName() {
                        return fAppName;
                    }
                });
                try {
                    bootstrap.startContainer((Environment)Environments.SERVLET, (Deployment)deploymentImpl);
                    bootstrap.startInitialization();
                    this.fireProcessInjectionTargetEvents(bootstrap, deploymentImpl);
                    bootstrap.deployBeans();
                }
                catch (Throwable t) {
                    DeploymentException de = new DeploymentException(t.getMessage());
                    de.initCause(t);
                    throw de;
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                    Thread.currentThread().setContextClassLoader(oldTCL);
                }
            }
        } else if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_STARTED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                final String fAppName = appInfo.getName();
                this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                    public String getName() {
                        return fAppName;
                    }
                });
                try {
                    bootstrap.validateBeans();
                    bootstrap.endInitialization();
                }
                catch (Throwable t) {
                    DeploymentException de = new DeploymentException(t.getMessage());
                    de.initCause(t);
                    throw de;
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                }
            }
        } else if (event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_STOPPED) || event.is(org.glassfish.internal.deployment.Deployment.APPLICATION_UNLOADED)) {
            DeploymentImpl deploymentImpl;
            String shutdown;
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            Application app = (Application)appInfo.getMetaData(Application.class);
            if (app != null) {
                for (BundleDescriptor next : app.getBundleDescriptors()) {
                    if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                    this.bundleToBeanDeploymentArchive.remove(next);
                }
                this.appToBootstrap.remove(app);
            }
            if (Boolean.valueOf(shutdown = (String)appInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)).equals(Boolean.TRUE)) {
                return;
            }
            WeldBootstrap bootstrap = (WeldBootstrap)appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap != null) {
                final String fAppName = appInfo.getName();
                this.invocationManager.pushAppEnvironment(new ApplicationEnvironment(){

                    public String getName() {
                        return fAppName;
                    }
                });
                try {
                    bootstrap.shutdown();
                }
                catch (Exception e) {
                    this._logger.log(Level.WARNING, "JCDI shutdown error", e);
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                }
                appInfo.addTransientAppMetaData(WELD_SHUTDOWN, (Object)"true");
            }
            if ((deploymentImpl = (DeploymentImpl)appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) != null) {
                deploymentImpl.cleanup();
            }
        }
    }

    private void fireProcessInjectionTargetEvents(WeldBootstrap bootstrap, DeploymentImpl impl) {
        Collection bdaList = impl.getBeanDeploymentArchives();
        boolean isFullProfile = false;
        Class<?> messageListenerClass = null;
        try {
            messageListenerClass = Thread.currentThread().getContextClassLoader().loadClass("javax.jms.MessageListener");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("javax.jms.MessageListener Class available, so need to fire PIT events to MDBs");
            }
            isFullProfile = true;
        }
        catch (ClassNotFoundException cnfe) {
            isFullProfile = false;
        }
        for (BeanDeploymentArchive bda : bdaList) {
            Collection<Class<?>> bdaClasses = ((BeanDeploymentArchiveImpl)bda).getBeanClassObjects();
            for (Class<?> bdaClazz : bdaClasses) {
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(bdaClazz)) continue;
                    this.firePITEvent(bootstrap, bda, bdaClazz);
                }
                if (!isFullProfile || !messageListenerClass.isAssignableFrom(bdaClazz)) continue;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine(bdaClazz + " is an MDB and so need " + "to fire a PIT event to it");
                }
                this.firePITEvent(bootstrap, bda, bdaClazz);
            }
        }
    }

    private void firePITEvent(WeldBootstrap bootstrap, BeanDeploymentArchive bda, Class<?> bdaClazz) {
        if (bdaClazz.isInterface()) {
            return;
        }
        AnnotatedType at = bootstrap.getManager(bda).createAnnotatedType(bdaClazz);
        InjectionTarget it = bootstrap.getManager(bda).fireProcessInjectionTarget(at);
        ((BeanDeploymentArchiveImpl)bda).putInjectionTarget(at, it);
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.get(bundle);
    }

    public boolean is299Enabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public WeldBootstrap getBootstrapForApp(Application app) {
        return this.appToBootstrap.get(app);
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        WebBundleDescriptor bundle;
        DeploymentImpl deploymentImpl;
        DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        ApplicationInfo appInfo = this.applicationRegistry.get(deployParams.name);
        ReadableArchive archive = context.getSource();
        WeldBootstrap bootstrap = (WeldBootstrap)context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        if (bootstrap == null) {
            bootstrap = new WeldBootstrap();
            Application app = (Application)context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
            context.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP, (Object)bootstrap);
        }
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        if (ejbBundle != null) {
            ejbs.addAll(ejbBundle.getEjbs());
            ejbServices = new EjbServicesImpl(this.services);
        }
        if ((deploymentImpl = (DeploymentImpl)context.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) == null) {
            deploymentImpl = new DeploymentImpl(archive, ejbs, context);
            TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.services);
            deploymentImpl.getServices().add(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)transactionServices);
            ValidationServicesImpl validationServices = new ValidationServicesImpl();
            deploymentImpl.getServices().add(ValidationServices.class, (org.jboss.weld.bootstrap.api.Service)validationServices);
            SecurityServicesImpl securityServices = new SecurityServicesImpl();
            deploymentImpl.getServices().add(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)securityServices);
            ProxyServicesImpl proxyServices = new ProxyServicesImpl(this.services);
            deploymentImpl.getServices().add(ProxyServices.class, (org.jboss.weld.bootstrap.api.Service)proxyServices);
        } else {
            deploymentImpl.scanArchive(archive, ejbs, context);
        }
        if (ejbBundle != null && !deploymentImpl.getServices().contains(EjbServices.class)) {
            deploymentImpl.getServices().add(EjbServices.class, (org.jboss.weld.bootstrap.api.Service)ejbServices);
        }
        BeanDeploymentArchive bda = deploymentImpl.getBeanDeploymentArchiveForArchive(archive.getName());
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (wDesc != null) {
            wDesc.setExtensionProperty(WELD_EXTENSION, "true");
            wDesc.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_LISTENER));
            wDesc.addAppListenerDescriptor((AppListenerDescriptor)new AppListenerDescriptorImpl(WELD_CONTEXT_LISTENER));
        }
        Object object = bundle = wDesc != null ? wDesc : ejbBundle;
        if (bundle != null) {
            InjectionManager injectionMgr = (InjectionManager)this.services.getService(InjectionManager.class, new Annotation[0]);
            InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionMgr, (BundleDescriptor)bundle);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "WeldDeployer:: Adding injectionServices " + injectionServices + " for " + bda.getId());
            }
            bda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
            if (bda.getBeanDeploymentArchives().size() != 0) {
                for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.FINE, "WeldDeployer:: Adding injectionServices " + injectionServices + " for " + subBda.getId());
                    }
                    subBda.getServices().add(InjectionServices.class, (org.jboss.weld.bootstrap.api.Service)injectionServices);
                }
            }
            this.bundleToBeanDeploymentArchive.put((BundleDescriptor)bundle, bda);
        }
        WeldApplicationContainer wbApp = new WeldApplicationContainer(bootstrap);
        context.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        appInfo.addTransientAppMetaData(WELD_DEPLOYMENT, (Object)deploymentImpl);
        return wbApp;
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }
}

