/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Globals;
import org.jboss.weld.injection.spi.InjectionContext;
import org.jboss.weld.injection.spi.InjectionServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionServicesImpl
implements InjectionServices {
    private InjectionManager injectionManager;
    private BundleDescriptor bundleContext;

    public InjectionServicesImpl(InjectionManager injectionMgr, BundleDescriptor context) {
        this.injectionManager = injectionMgr;
        this.bundleContext = context;
    }

    public <T> void aroundInject(InjectionContext<T> injectionContext) {
        try {
            Services h = Globals.getDefaultServices();
            ComponentEnvManager compEnvManager = (ComponentEnvManager)h.forContract(ComponentEnvManager.class).get();
            EjbContainerServices containerServices = (EjbContainerServices)h.forContract(EjbContainerServices.class).get();
            JndiNameEnvironment componentEnv = compEnvManager.getCurrentJndiNameEnvironment();
            ManagedBeanDescriptor mbDesc = null;
            JndiNameEnvironment injectionEnv = (JndiNameEnvironment)this.bundleContext;
            Object target = injectionContext.getTarget();
            String targetClass = target.getClass().getName();
            if (componentEnv == null) {
                System.err.println("No valid EE environment for injection of " + targetClass);
                injectionContext.proceed();
                return;
            }
            if (componentEnv instanceof EjbDescriptor) {
                EjbDescriptor ejbDesc = (EjbDescriptor)componentEnv;
                if (containerServices.isEjbManagedObject((Object)ejbDesc, target.getClass())) {
                    injectionEnv = componentEnv;
                } else if (this.bundleContext instanceof EjbBundleDescriptor) {
                    mbDesc = this.bundleContext.getManagedBeanByBeanClass(targetClass);
                }
            }
            if (mbDesc != null) {
                this.injectionManager.injectInstance(target, mbDesc.getGlobalJndiName(), false);
            } else if (injectionEnv instanceof EjbBundleDescriptor) {
                this.injectionManager.injectInstance(target, compEnvManager.getComponentEnvId(injectionEnv), false);
            } else {
                this.injectionManager.injectInstance(target, injectionEnv, false);
            }
            injectionContext.proceed();
        }
        catch (InjectionException ie) {
            throw new IllegalStateException(ie.getMessage(), ie);
        }
    }

    public void cleanup() {
    }
}

