/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ModelBinding;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-virtual-server")
@PerLookup
@I18n(value="create.virtual.server")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateVirtualServer
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    protected static final String CREATE_VIRTUAL_SERVER_BOTH_HTTP_NETWORK = "AS-WEB-ADMIN-00024";
    protected static final String CREATE_VIRTUAL_SERVER_DUPLICATE = "AS-WEB-ADMIN-00025";
    protected static final String CREATE_VIRTUAL_SERVER_FAIL = "AS-WEB-ADMIN-00026";
    @Param(name="hosts", defaultValue="${com.sun.aas.hostName}")
    String hosts;
    @Param(name="httplisteners", optional=true)
    String httpListeners;
    @Param(name="networklisteners", optional=true)
    String networkListeners;
    @Param(name="defaultwebmodule", optional=true)
    String defaultWebModule;
    @Param(name="state", defaultValue="on", acceptableValues="on, off, disabled", optional=true)
    String state;
    @Param(name="logfile", optional=true)
    @ModelBinding(type=VirtualServer.class, getterMethodName="getLogFile")
    String logFile;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="virtual_server_id", primary=true)
    String virtualServerId;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        if (this.networkListeners != null && this.httpListeners != null) {
            report.setMessage(MessageFormat.format(rb.getString(CREATE_VIRTUAL_SERVER_BOTH_HTTP_NETWORK), this.virtualServerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.networkListeners == null) {
            this.networkListeners = this.httpListeners;
        }
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer virtualServer : httpService.getVirtualServer()) {
            if (!virtualServer.getId().equals(this.virtualServerId)) continue;
            report.setMessage(MessageFormat.format(rb.getString(CREATE_VIRTUAL_SERVER_DUPLICATE), this.virtualServerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    String docroot = "${com.sun.aas.instanceRoot}/docroot";
                    String accessLog = "${com.sun.aas.instanceRoot}/logs/access";
                    VirtualServer newVirtualServer = (VirtualServer)param.createChild(VirtualServer.class);
                    newVirtualServer.setId(CreateVirtualServer.this.virtualServerId);
                    newVirtualServer.setHosts(CreateVirtualServer.this.hosts);
                    newVirtualServer.setNetworkListeners(CreateVirtualServer.this.networkListeners);
                    newVirtualServer.setDefaultWebModule(CreateVirtualServer.this.defaultWebModule);
                    newVirtualServer.setState(CreateVirtualServer.this.state);
                    newVirtualServer.setLogFile(CreateVirtualServer.this.logFile);
                    if (CreateVirtualServer.this.properties != null) {
                        for (Map.Entry<Object, Object> entry : CreateVirtualServer.this.properties.entrySet()) {
                            String pn = (String)entry.getKey();
                            String pv = (String)entry.getValue();
                            if ("docroot".equals(pn)) {
                                docroot = pv;
                                continue;
                            }
                            if ("accesslog".equals(pn)) {
                                accessLog = pv;
                                continue;
                            }
                            Property property = (Property)newVirtualServer.createChild(Property.class);
                            property.setName(pn);
                            property.setValue(pv);
                            newVirtualServer.getProperty().add(property);
                        }
                    }
                    newVirtualServer.setDocroot(docroot);
                    newVirtualServer.setAccessLog(accessLog);
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, (ConfigBeanProxy)httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(CREATE_VIRTUAL_SERVER_FAIL), this.virtualServerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

