/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.monitor.HttpServiceStatsProvider;
import org.glassfish.web.admin.monitor.VirtualServerInfoStatsProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigurationException;

@Service(name="http-service")
@Singleton
public class HttpServiceStatsProviderBootstrap
implements PostConstruct {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.web.admin.monitor.LogMessages";
    private static final String WEB_ADMIN_LOGGER = "javax.enterprise.web.admin";
    public static final Logger logger = Logger.getLogger("javax.enterprise.web.admin", "org.glassfish.web.admin.monitor.LogMessages");
    public static final String UNABLE_TO_REGISTER_STATS_PROVIDERS = "AS-WEB-ADMIN-00001";
    public static final String NULL_CONFIG = "AS-WEB-ADMIN-00002";

    public void postConstruct() {
        if (this.config == null) {
            Object[] params = new Object[]{VirtualServerInfoStatsProvider.class.getName(), HttpServiceStatsProvider.class.getName(), "http service", "virtual server"};
            logger.log(Level.SEVERE, UNABLE_TO_REGISTER_STATS_PROVIDERS, params);
            throw new ConfigurationException(logger.getResourceBundle().getString(NULL_CONFIG));
        }
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + vs.getId()), (Object)new VirtualServerInfoStatsProvider(vs));
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + vs.getId() + "/request"), (Object)new HttpServiceStatsProvider(vs.getId(), vs.getNetworkListeners(), this.config.getNetworkConfig()));
        }
    }
}

