/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.HttpServiceStatsProvider;
import org.glassfish.web.admin.monitor.VirtualServerInfoStatsProvider;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigurationException;

@Service(name="http-service")
@Scoped(value=Singleton.class)
public class HttpServiceStatsProviderBootstrap
implements PostConstruct {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final Logger logger = LogDomains.getLogger(HttpServiceStatsProviderBootstrap.class, (String)"javax.enterprise.system.container.web");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(HttpServiceStatsProviderBootstrap.class);

    public void postConstruct() {
        if (this.config == null) {
            Object[] params = new Object[]{VirtualServerInfoStatsProvider.class.getName(), HttpServiceStatsProvider.class.getName(), "http service", "virtual server"};
            logger.log(Level.SEVERE, "unableToRegisterStatsProviders", params);
            throw new ConfigurationException(localStrings.getLocalString("nullConfig", "Current server config is null."));
        }
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + vs.getId()), (Object)new VirtualServerInfoStatsProvider(vs));
            StatsProviderManager.register((String)"http-service", (PluginPoint)PluginPoint.SERVER, (String)("http-service/" + vs.getId() + "/request"), (Object)new HttpServiceStatsProvider(vs.getId(), vs.getNetworkListeners(), this.config.getNetworkConfig()));
        }
    }
}

