/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-transport")
@Scoped(value=PerLookup.class)
@I18n(value="delete.transport")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteTransport
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteTransport.class);
    @Param(name="transportname", primary=true)
    String transportName;
    Transport transportToBeRemoved = null;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Services services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.byType(Target.class).get();
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Transports transports = networkConfig.getTransports();
        try {
            for (Transport transport : transports.getTransport()) {
                if (!this.transportName.equalsIgnoreCase(transport.getName())) continue;
                this.transportToBeRemoved = transport;
            }
            if (this.transportToBeRemoved == null) {
                report.setMessage(localStrings.getLocalString("delete.transport.notexists", "{0} transport doesn't exist", new Object[]{this.transportName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List nwlsnrList = this.transportToBeRemoved.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.transportToBeRemoved.getName().equals(nwlsnr.getTransport())) continue;
                report.setMessage(localStrings.getLocalString("delete.transport.beingused", "{0} transport is being used in the network listener {1}", new Object[]{this.transportName, nwlsnr.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) {
                    param.getTransport().remove(DeleteTransport.this.transportToBeRemoved);
                    return DeleteTransport.this.transportToBeRemoved;
                }
            }, (ConfigBeanProxy)transports);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.transport.fail", "Deletion of Transport {0} failed", new Object[]{this.transportName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

