/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;

public class ServiceRefCheck
extends WSClientTest
implements WSClientCheck {
    @Override
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        if (descriptor.hasGenericServiceInterface()) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The JAX-RPC Service interface the client depends on is the Generic Service Interface."));
        } else if (descriptor.hasGeneratedServiceInterface()) {
            String intf = descriptor.getServiceInterface();
            try {
                Class<?> cl = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "The JAX-RPC Service interface the client depends on is a Generated Service Interface [{0}].", new Object[]{intf}));
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The JAX-RPC Service interface the client depends on [{0}] could not be loaded.", new Object[]{intf}));
                pass = false;
            }
        } else {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"Service Interface Neither Generic nor Generated"}));
        }
        return result;
    }
}

