/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.elements.MimeTypes;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import org.glassfish.web.deployment.descriptor.MimeMappingDescriptor;

public class MimeTypeElement
extends WebTest
implements WebCheck,
MimeTypes {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getMimeMappings().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e = descriptor.getMimeMappings();
            while (e.hasMoreElements()) {
                foundIt = false;
                MimeMappingDescriptor mimemapping = (MimeMappingDescriptor)e.nextElement();
                String mimeType = mimemapping.getMimeType();
                this.logger.log(Level.FINE, "servlet mimeType: " + mimeType);
                int pos = mimeType.indexOf("/");
                if (mimeType.substring(pos + 1).startsWith("X-") || mimeType.substring(pos + 1).startsWith("x-")) {
                    foundIt = true;
                } else if (mimeType.startsWith("X-")) {
                    foundIt = true;
                } else if (mimeType.substring(0, pos).equals("text")) {
                    if (Arrays.asList(text).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("multipart")) {
                    if (Arrays.asList(multipart).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("message")) {
                    if (Arrays.asList(message).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("application")) {
                    if (Arrays.asList(application).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("image")) {
                    if (Arrays.asList(image).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("audio")) {
                    if (Arrays.asList(audio).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("video")) {
                    if (Arrays.asList(video).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                        foundIt = true;
                    }
                } else if (mimeType.substring(0, pos).equals("model") && Arrays.asList(model).contains(mimeType.substring(pos + 1, mimeType.length()))) {
                    foundIt = true;
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Servlet mime-type [ {0} ] defined for this web application [ {1} ]", new Object[]{mimeType, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Servlet mime-type [ {0} ] not defined for this web application [ {1} ]", new Object[]{mimeType, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no mimemappings within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

