/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Enumeration;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class TransactionDemarcationType
extends EjbTest
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getHomeHandle", "getEJBMetaData", "getEJBHome", "getEJBLocalHome", "getHandle", "getPrimaryKey", "isIdentical"};

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                boolean oneFailed = false;
                String transactionType = descriptor.getTransactionType();
                if ("Container".equals(transactionType)) {
                    try {
                        Arrays.sort(EJBObjectMethods);
                        ContainerTransaction containerTransaction = null;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee = descriptor.getMethodContainerTransactions().keys();
                            while (ee.hasMoreElements()) {
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                                if (Arrays.binarySearch(EJBObjectMethods, methodDescriptor.getName()) < 0) {
                                    containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                    if (containerTransaction != null && containerTransaction.getTransactionAttribute() != null) {
                                        String transactionAttribute = containerTransaction.getTransactionAttribute();
                                        if ("NotSupported".equals(transactionAttribute) || "Supports".equals(transactionAttribute) || "Required".equals(transactionAttribute) || "RequiresNew".equals(transactionAttribute) || "Mandatory".equals(transactionAttribute) || "Never".equals(transactionAttribute)) {
                                            this.addGoodDetails(result, compName);
                                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "TransactionAttribute [ {0} ] for method [ {1} ] is valid.", new Object[]{transactionAttribute, methodDescriptor.getName()}));
                                            continue;
                                        }
                                        oneFailed = true;
                                        this.addErrorDetails(result, compName);
                                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.", new Object[]{transactionAttribute, methodDescriptor.getName()}));
                                        continue;
                                    }
                                    if (this.getVerifierContext().getJavaEEVersion().compareTo("5") >= 0) continue;
                                    oneFailed = true;
                                    this.addErrorDetails(result, compName);
                                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                String ejbClass = methodDescriptor.getEjbClassSymbol();
                                boolean session = descriptor instanceof EjbSessionDescriptor;
                                boolean entity = descriptor instanceof EjbEntityDescriptor;
                                if ((ejbClass == null || ejbClass.equals("Home") || ejbClass.equals("LocalHome")) && session) {
                                    oneFailed = true;
                                    this.addErrorDetails(result, compName);
                                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failedHome", "Error: TransactionAttribute for method [ {0} ] is not valid. Home or Local Home interface methods of a session bean must not hvae a transaction attribute.", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                if ((ejbClass == null || ejbClass.equals("Remote") || ejbClass.equals("Local")) && session && methodDescriptor.getName().equals("remove")) {
                                    if (methodDescriptor.getParameterClassNames() == null || methodDescriptor.getParameterClassNames().length == 0) {
                                        oneFailed = true;
                                        this.addErrorDetails(result, compName);
                                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failedComp", "Error: TransactionAttribute for method [ {0} ] is not valid. 'remove' method in Remote/Local interface of a session bean must not have a transaction attribute.", new Object[]{methodDescriptor.getName()}));
                                        continue;
                                    }
                                    this.addGoodDetails(result, compName);
                                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                if ((ejbClass == null || ejbClass.equals("Home") || ejbClass.equals("LocalHome")) && entity) {
                                    if (methodDescriptor.getParameterClassNames() == null || methodDescriptor.getParameterClassNames().length == 0) {
                                        oneFailed = true;
                                        this.addErrorDetails(result, compName);
                                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: TransactionAttribute for method [ {0} ] is not valid. ", new Object[]{methodDescriptor.getName()}));
                                        continue;
                                    }
                                    this.addGoodDetails(result, compName);
                                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                if (ejbClass != null && !ejbClass.equals("Remote") && !ejbClass.equals("Local") || !entity) continue;
                                if (methodDescriptor.getName().equals("isIdentical")) {
                                    if (methodDescriptor.getParameterClassNames() == null || methodDescriptor.getParameterClassNames().length == 0) {
                                        this.addGoodDetails(result, compName);
                                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                        continue;
                                    }
                                    String[] paramList = methodDescriptor.getParameterClassNames();
                                    if (Array.getLength(paramList) == 1) {
                                        if (paramList[0].equals("javax.ejb.EJBObject")) {
                                            oneFailed = true;
                                            this.addErrorDetails(result, compName);
                                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: TransactionAttribute for method [ {0} ] is not valid.", new Object[]{methodDescriptor.getName()}));
                                            continue;
                                        }
                                        this.addGoodDetails(result, compName);
                                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                        continue;
                                    }
                                    this.addGoodDetails(result, compName);
                                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                if (methodDescriptor.getName().equals("remove")) {
                                    this.addGoodDetails(result, compName);
                                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedTest", "TransactionAttribute for method [ {0} ] is valid.", new Object[]{methodDescriptor.getName()}));
                                    continue;
                                }
                                if (methodDescriptor.getParameterClassNames() != null && methodDescriptor.getParameterClassNames().length != 0) continue;
                                oneFailed = true;
                                this.addErrorDetails(result, compName);
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: [ {0} ] should not have a Transaction Attribute", new Object[]{methodDescriptor.getName()}));
                            }
                        } else {
                            this.addNaDetails(result, compName);
                            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                        }
                    }
                    catch (Exception e) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), e.getMessage(), descriptor.getName()}));
                        return result;
                    }
                    if (oneFailed) {
                        result.setStatus(1);
                    } else {
                        result.setStatus(0);
                    }
                    return result;
                }
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Bean [ {0} ] is not {1} managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), "Container", transactionType}));
                return result;
            }
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
            return result;
        }
        catch (Throwable t) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t.getMessage(), descriptor.getName()}));
            return result;
        }
    }
}

