/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ASMMethod;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Method;
import com.sun.enterprise.tools.verifier.apiscan.classfile.MethodRef;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ASMClassFile
implements ClassFile {
    private static Logger logger = Logger.getLogger("apiscan.classfile");
    private String externalName;
    private String internalName;
    private String packageName;
    private ClassReader cr;
    private Set<Method> methods = new HashSet<Method>();
    private String internalNameOfSuperClass;
    private String[] internalNamesOfInterfaces;
    private int access;

    @Override
    public boolean isInterface() {
        return (this.access & 0x200) == 512;
    }

    @Override
    public Method getMethod(MethodRef methodRef) {
        for (Method m : this.methods) {
            if (!m.getName().equals(methodRef.getName()) || !m.getDescriptor().equals(methodRef.getDescriptor())) continue;
            return m;
        }
        return null;
    }

    public Collection<Method> getMethods() {
        return this.methods;
    }

    public ASMClassFile(InputStream is) throws IOException {
        this.cr = new ClassReader(is);
        this.cr.accept((ClassVisitor)new MyVisitor(this), 1);
        is.close();
    }

    @Override
    public Collection<String> getAllReferencedClassNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection getAllReferencedClassNamesInInternalForm() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.externalName;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getNameOfSuperClass() {
        return Util.convertToExternalClassName(this.internalNameOfSuperClass);
    }

    @Override
    public String getInternalNameOfSuperClass() {
        return this.internalNameOfSuperClass;
    }

    @Override
    public String[] getNamesOfInterfaces() {
        String[] result = new String[this.internalNamesOfInterfaces.length];
        for (int i = 0; i < this.internalNamesOfInterfaces.length; ++i) {
            result[i] = Util.convertToExternalClassName(this.internalNamesOfInterfaces[i]);
        }
        return result;
    }

    @Override
    public String[] getInternalNamesOfInterfaces() {
        return this.internalNamesOfInterfaces;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ASMClassFile.decodeAccessFlag(this.access) + this.externalName);
        if (this.internalNameOfSuperClass != null) {
            sb.append(" extends " + this.getNameOfSuperClass());
        }
        if (this.internalNamesOfInterfaces.length > 0) {
            sb.append(" implements ");
            for (String s : this.getNamesOfInterfaces()) {
                sb.append(s);
            }
        }
        sb.append("{\n");
        for (Method m : this.methods) {
            sb.append(m).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String decodeAccessFlag(int access) {
        StringBuilder result = new StringBuilder("");
        if ((access & 2) == 2) {
            result.append("private ");
        } else if ((access & 4) == 4) {
            result.append("protected ");
        } else if ((access & 1) == 1) {
            result.append("public ");
        }
        if ((access & 0x400) == 1024) {
            result.append("abstract ");
        } else if ((access & 0x10) == 16) {
            result.append("final ");
        }
        if ((access & 0x200) == 512) {
            result.append("interface ");
        } else {
            result.append("class ");
        }
        return result.toString();
    }

    static /* synthetic */ String[] access$402(ASMClassFile x0, String[] x1) {
        x0.internalNamesOfInterfaces = x1;
        return x1;
    }

    private static class MyVisitor
    extends ClassVisitor {
        ASMClassFile cf;

        public MyVisitor(ASMClassFile cf) {
            super(393216);
            this.cf = cf;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMClassFile$MyVisitor", "visit", new Object[]{version, access, name, signature});
            this.cf.internalName = name;
            this.cf.externalName = Util.convertToExternalClassName(name);
            this.cf.internalNameOfSuperClass = superName;
            ASMClassFile.access$402(this.cf, interfaces);
            int index = name.lastIndexOf(47);
            if (index < 0) {
                this.cf.packageName = "";
            } else {
                this.cf.packageName = name.substring(0, index);
            }
            this.cf.access = access;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            logger.entering("com.sun.enterprise.tools.verifier.apiscan.classfile.ASMClassFile$MyVisitor", "visitMethod", new Object[]{access, name, signature, desc});
            ASMMethod method = new ASMMethod(this.cf, name, desc, access, signature, exceptions);
            this.cf.methods.add(method);
            return method;
        }

        public void visitEnd() {
            logger.entering("ASMClassFile$MyVisitor", "visitEnd", new Object[]{this.cf.getName()});
        }
    }
}

