/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.wsclient;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;

public class WebServiceClientCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesWebServicesClient.xml";
    private static final String sunONETestsListFileName = WebServiceClientCheckMgrImpl.getSunPrefix().concat("TestNamesWebServicesClient.xml");
    private String moduleName;

    public WebServiceClientCheckMgrImpl(VerifierFrameworkContext verifierFrameworkContext) {
        this.verifierFrameworkContext = verifierFrameworkContext;
    }

    @Override
    public void check(Descriptor descriptor) throws Exception {
        ServiceReferenceDescriptor rootDescriptor = (ServiceReferenceDescriptor)descriptor;
        ArchiveType moduleType = rootDescriptor.getBundleDescriptor().getModuleType();
        if (moduleType != null && moduleType.equals((Object)DOLUtils.ejbType())) {
            this.moduleName = "ejb";
        } else if (moduleType != null && moduleType.equals((Object)DOLUtils.warType())) {
            this.moduleName = "web";
        } else if (moduleType != null && moduleType.equals((Object)DOLUtils.carType())) {
            this.moduleName = "appclient";
        }
        super.check((Descriptor)rootDescriptor);
    }

    @Override
    protected String getTestsListFileName() {
        return testsListFileName;
    }

    @Override
    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    @Override
    protected String getSchemaVersion(Descriptor descriptor) {
        String wsclientVersion = null;
        String version = ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor().getSpecVersion();
        if (this.moduleName.equals("ejb")) {
            if ("2.1".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("3.0".equals(version)) {
                wsclientVersion = "1.2";
            }
        } else if (this.moduleName.equals("web")) {
            if ("2.4".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("2.5".equals(version)) {
                wsclientVersion = "1.2";
            }
        } else if (this.moduleName.equals("appclient")) {
            if ("1.4".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("5".equals(version)) {
                wsclientVersion = "1.2";
            }
        }
        if (wsclientVersion == null) {
            wsclientVersion = "";
        }
        return wsclientVersion;
    }

    @Override
    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }

    @Override
    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor();
    }

    @Override
    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((ServiceReferenceDescriptor)descriptor);
    }
}

