/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import javax.xml.namespace.QName;

public class WSWsdlPort
extends WSTest
implements WSCheck {
    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        try {
            QName wsdlport = descriptor.getWsdlPort();
            if (wsdlport != null) {
                String localpart = wsdlport.getLocalPart();
                if (localpart == null || localpart.equals("")) {
                    pass = false;
                }
            } else {
                pass = false;
            }
            if (pass) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The wsdl-port in the webservices.xml file for [{0}] is specified for the endpoint", new Object[]{compName.toString()}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The  wsdl-port in the webservices.xml file for [{0}] is not correctly specified for the endpoint", new Object[]{compName.toString()}));
            }
        }
        catch (Exception e) {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        return result;
    }
}

