/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.EndPointImplBeanClassChecker;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Vector;

public class JAXRPCServiceImplBeanChk
extends WSTest
implements WSCheck {
    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        if (descriptor.implementedByWebComponent()) {
            Class bean = this.loadImplBeanClass(descriptor, result);
            if (bean == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"Could not Load the Service Implementation Bean class for the JAX-RPC Endpoint"}));
            } else {
                Class sei;
                String s = descriptor.getServiceEndpointInterface();
                if (s == null || s.length() == 0) {
                    result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"SEI Class Name is Null"}));
                }
                if ((sei = this.loadSEIClass(descriptor, result)) == null) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.WSTest.SEIClassExists", "Error: Service Endpoint Interface class [ {0} ]  not found.", new Object[]{descriptor.getServiceEndpointInterface()}));
                } else {
                    boolean implementsSEI = sei.isAssignableFrom(bean);
                    EndPointImplBeanClassChecker checker = new EndPointImplBeanClassChecker(sei, bean, result, false);
                    if (implementsSEI) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean implements SEI"}));
                    } else {
                        Vector notImpl = checker.getSEIMethodsNotImplemented();
                        if (notImpl.size() > 0) {
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Implementation Bean Does not Implement ALL SEI Methods"}));
                        } else {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean implements  all Methods of the SEI"}));
                        }
                    }
                    if (checker.check(compName)) {
                        result.setStatus(0);
                    } else {
                        result.setStatus(1);
                    }
                }
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.notapp", "[{0}]", new Object[]{"Not Applicable since this is an EJB Service Endpoint"}));
        }
        return result;
    }
}

