/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.web.TagDescriptor;
import javax.servlet.jsp.tagext.DynamicAttributes;

public class TagClassImplementsValidInterface
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        VerifierTestContext context = this.getVerifierContext();
        Result result = this.getInitializedResult();
        ClassLoader cl = context.getClassLoader();
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            if (tld.getSpecVersion().compareTo("2.0") < 0) continue;
            for (TagDescriptor tagdesc : tld.getTagDescriptors()) {
                Class<?> c = null;
                try {
                    c = Class.forName(tagdesc.getTagClass(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (!tagdesc.getDynamicAttributes().equalsIgnoreCase("true") || DynamicAttributes.class.isAssignableFrom(c)) continue;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: tag class [ {0} ] in [ {1} ] does not implements interface javax.servlet.jsp.tagext.DynamicAttributes", new Object[]{c.getName(), tld.getUri()}));
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "All tag-class defined in the tag lib descriptor files implement valid interface"));
        }
        return result;
    }
}

