/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class EjbClassImplementsComponentInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbSessionDescriptor)descriptor);
            }
        }
        if (this.result.getStatus() != 1 && this.result.getStatus() != 2) {
            this.addGoodDetails(this.result, this.compName);
            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Bean class does not implement the enterprise Bean's remote interface"));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String component, EjbSessionDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            Class<?> rc = Class.forName(component, false, this.getVerifierContext().getClassLoader());
            block2: do {
                for (Class<?> interfaces : c.getInterfaces()) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces.getName()});
                    if (!interfaces.getName().equals(rc.getName())) continue;
                    this.addWarningDetails(this.result, this.compName);
                    this.result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] class implments the enterprise Bean's remote interface [ {1} ].  It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result. ", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                    continue block2;
                }
            } while ((c = c.getSuperclass()) != null);
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
        }
    }
}

