/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class EjbFinderMethodArgs
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Bean".equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean isLegalRMIIIOP = false;
                boolean oneFailed = false;
                int foundAtLeastOne = 0;
                try {
                    VerifierTestContext context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                    if (descriptor.getHomeClassName() == null || descriptor.getHomeClassName().equals("")) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
                        return result;
                    }
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        for (int j = 0; j < ejbFinderMethods.length; ++j) {
                            if (!ejbFinderMethods[j].getName().startsWith("ejbFind")) continue;
                            ejbFindMethodFound = true;
                            ++foundAtLeastOne;
                            Class[] ejbFinderMethodParameterTypes = ejbFinderMethods[j].getParameterTypes();
                            if (RmiIIOPUtils.isValidRmiIIOPParameters(ejbFinderMethodParameterTypes)) {
                                isLegalRMIIIOP = true;
                            }
                            if (ejbFindMethodFound && isLegalRMIIIOP) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "An [ {0} ] method was found, with valid method arguments types for RMI-IIOP.", new Object[]{ejbFinderMethods[j].getName()}));
                                continue;
                            }
                            if (!ejbFindMethodFound || isLegalRMIIIOP) continue;
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: An [ {0} ] method was found, but [ {1} ] method has illegal parameter values.  [ {2} ] methods arguments types must be legal types for RMI-IIOP.", new Object[]{ejbFinderMethods[j].getName(), ejbFinderMethods[j].getName(), ejbFinderMethods[j].getName()}));
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Bean", descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

