/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class EjbClassExist
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Bean class [ {0} ] exist and is loadable.", new Object[]{descriptor.getEjbClassName()}));
        }
        catch (NoClassDefFoundError e) {
            this.logger.log(Level.FINE, "Can't find class " + e.getMessage());
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Bean class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Bean class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
        }
        catch (Exception e) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Bean class [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
        }
        return result;
    }
}

