/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.Collection;
import java.util.Map;
import org.glassfish.deployment.common.Descriptor;

public abstract class AbstractPUMatchingEMandEMFRefTest
extends VerifierTest
implements VerifierCheck {
    static final String className = AbstractPUMatchingEMandEMFRefTest.class.getName();

    @Override
    public Result check(Descriptor descriptor) {
        PersistenceUnitDescriptor pu;
        String referringUnitName;
        Result result = this.getInitializedResult();
        this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
        result.setStatus(0);
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor(descriptor);
        for (EntityManagerReferenceDescriptor emRefDesc : this.getEntityManagerReferenceDescriptors(descriptor)) {
            referringUnitName = emRefDesc.getUnitName();
            pu = bundleDescriptor.findReferencedPU(referringUnitName);
            if (pu == null) {
                result.failed(smh.getLocalString(className + "failed", "There is no unique persistence unit found by name [ {0} ] in the scope of this component.", new Object[]{referringUnitName}));
                continue;
            }
            result.passed(smh.getLocalString(className + "passed", "Found a persistence unit by name [ {0} ] in the scope of this component", new Object[]{referringUnitName}));
        }
        for (EntityManagerFactoryReferenceDescriptor emfRefDesc : this.getEntityManagerFactoryReferenceDescriptors(descriptor)) {
            referringUnitName = emfRefDesc.getUnitName();
            pu = bundleDescriptor.findReferencedPU(referringUnitName);
            if (pu == null) {
                result.failed(smh.getLocalString(className + "failed", "There is no unique persistence unit found by name [ {0} ] in the scope of this component.", new Object[]{referringUnitName}));
                continue;
            }
            result.passed(smh.getLocalString(className + "passed", "Found a persistence unit by name [ {0} ] in the scope of this component", new Object[]{referringUnitName}));
        }
        StringBuilder visiblePUNames = new StringBuilder();
        Map visiblePUs = bundleDescriptor.getVisiblePUs();
        int count = 0;
        for (String puName : visiblePUs.keySet()) {
            visiblePUNames.append(puName);
            if (visiblePUs.size() == ++count) continue;
            visiblePUNames.append(", ");
        }
        String message = smh.getLocalString(className + ".puList", "PUs that are visible to this component are: [ {0} ]", new Object[]{visiblePUNames});
        result.addErrorDetails(message);
        result.addGoodDetails(message);
        return result;
    }

    protected abstract BundleDescriptor getBundleDescriptor(Descriptor var1);

    protected abstract Collection<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors(Descriptor var1);

    protected abstract Collection<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors(Descriptor var1);
}

