/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.persistence;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public class PersistenceUnitCheckMgrImpl
extends CheckMgr {
    private String moduleName;
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public PersistenceUnitCheckMgrImpl(VerifierFrameworkContext verifierFrameworkContext, VerifierTestContext context) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.context = context;
    }

    @Override
    protected void check(Descriptor descriptor) throws Exception {
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        RootDeploymentDescriptor rootDD = pu.getParent().getParent();
        if (rootDD.isApplication()) {
            this.moduleName = "application";
        } else {
            ModuleDescriptor mdesc = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
            ArchiveType moduleType = mdesc.getModuleType();
            if (moduleType != null && moduleType.equals((Object)DOLUtils.ejbType())) {
                this.moduleName = "ejb";
            } else if (moduleType != null && moduleType.equals((Object)DOLUtils.warType())) {
                this.moduleName = "web";
            } else if (moduleType != null && moduleType.equals((Object)DOLUtils.carType())) {
                this.moduleName = "appclient";
            } else {
                throw new RuntimeException(this.smh.getLocalString(this.getClass().getName() + ".exception", "Unknown module type : {0}", new Object[]{moduleType}));
            }
        }
        super.check(descriptor);
    }

    @Override
    protected void setRuntimeDDPresent(String uri) {
        this.isDDPresent = false;
    }

    @Override
    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor));
    }

    @Override
    protected String getTestsListFileName() {
        return "TestNamesPersistence.xml";
    }

    @Override
    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }

    @Override
    protected String getSchemaVersion(Descriptor descriptor) {
        return ((PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor)).getParent().getSpecVersion();
    }

    @Override
    protected String getSunONETestsListFileName() {
        return null;
    }

    @Override
    protected String getAbstractArchiveUri(Descriptor descriptor) {
        String archBase = this.context.getAbstractArchive().getURI().toString();
        RootDeploymentDescriptor rootDD = ((PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor)).getParent().getParent();
        if (rootDD.isApplication()) {
            return archBase;
        }
        ModuleDescriptor mdesc = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
        if (mdesc.isStandalone()) {
            return archBase;
        }
        return archBase + "/" + FileUtils.makeFriendlyFilename((String)mdesc.getArchiveUri());
    }
}

