/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class ExceptionType
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.loadWarFile(descriptor);
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getErrorPageDescriptors().hasMoreElements()) {
            boolean oneFailed = false;
            int oneExceptionType = 0;
            int oneNA = 0;
            boolean foundIt = false;
            Enumeration e = descriptor.getErrorPageDescriptors();
            while (e.hasMoreElements()) {
                foundIt = false;
                ++oneExceptionType;
                ErrorPageDescriptor errorpage = (ErrorPageDescriptor)e.nextElement();
                if (errorpage.getErrorCode() == 0) {
                    String exceptionType = errorpage.getExceptionType();
                    if (exceptionType != null && exceptionType.length() > 0) {
                        boolean isValidExceptionType = false;
                        try {
                            Class c = this.loadClass(result, exceptionType);
                            if (ExceptionType.isSubclassOf(c, "java.lang.Exception")) {
                                isValidExceptionType = true;
                            }
                        }
                        catch (Exception ex) {
                            isValidExceptionType = false;
                        }
                        foundIt = isValidExceptionType;
                        if (foundIt) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Exception type [ {0} ] contains a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{exceptionType, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{exceptionType, descriptor.getName()}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    Integer errorCode = new Integer(errorpage.getErrorCode());
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                    ++oneNA;
                    continue;
                }
                Integer errorCode = new Integer(errorpage.getErrorCode());
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Exception type is null, using error-code [ {0} ] instead within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                ++oneNA;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneNA == oneExceptionType) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no exception-type elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

