/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.CLIPParser;
import com.sun.enterprise.tools.verifier.LongOption;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import com.sun.enterprise.tools.verifier.util.VerifierFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Initializer {
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private VerifierFrameworkContext verifierFrameworkContext = new VerifierFrameworkContext();
    private String _FOStr = "Failures only";
    private String _WFOStr = "Warning and Failures only";
    private String _AOStr = "All";

    public Initializer(String[] args) {
        this.parseArgs(args);
    }

    public VerifierFrameworkContext getVerificationContext() {
        return this.verifierFrameworkContext;
    }

    private void parseArgs(String[] argv) {
        int c;
        boolean isVerboseSet = false;
        LongOption[] longopts = new LongOption[20];
        StringBuffer sb = new StringBuffer();
        longopts[0] = new LongOption("help", false, null, 104);
        longopts[1] = new LongOption("timestamp", false, null, 116);
        longopts[2] = new LongOption("verbose", false, null, 118);
        longopts[3] = new LongOption("version", false, null, 86);
        longopts[4] = new LongOption("destdir", true, sb, 100);
        longopts[5] = new LongOption("reportlevel", true, sb, 114);
        longopts[6] = new LongOption("gui", false, null, 117);
        longopts[7] = new LongOption("app", false, null, 97);
        longopts[8] = new LongOption("appclient", false, null, 65);
        longopts[9] = new LongOption("connector", false, null, 99);
        longopts[10] = new LongOption("ejb", false, null, 101);
        longopts[11] = new LongOption("web", false, null, 119);
        longopts[12] = new LongOption("webservices", false, null, 115);
        longopts[13] = new LongOption("webservicesclient", false, null, 108);
        longopts[14] = new LongOption("persistence", false, null, 80);
        longopts[15] = new LongOption("configdir", true, null, 67);
        longopts[16] = new LongOption("portability", false, null, 112);
        longopts[17] = new LongOption("domain", true, null, 68);
        longopts[18] = new LongOption("extDir", true, null, 69);
        longopts[19] = new LongOption("mode", true, null, 109);
        String[] levels = new String[]{"a", "w", "f", "all", "warnings", "failures"};
        CLIPParser parser = null;
        parser = new CLIPParser("verifier", argv, "-:vtVhud:r:aAcewslC:pPm:D:E:", longopts);
        block25: while ((c = parser.getopt()) != -1) {
            switch (c) {
                case 0: {
                    String arg = parser.getOptarg();
                    this.processValidLongOpt((char)new Integer(sb.toString()).intValue(), arg, levels);
                    break;
                }
                case 118: {
                    this.logger.setLevel(Level.FINEST);
                    isVerboseSet = true;
                    Handler[] handler = Logger.getLogger("").getHandlers();
                    for (int i = 0; i < handler.length; ++i) {
                        handler[i].setLevel(Level.FINEST);
                    }
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.verboseFlag");
                    break;
                }
                case 116: {
                    this.verifierFrameworkContext.setUseTimeStamp(true);
                    break;
                }
                case 104: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.helpMessage");
                    this.usage();
                    break;
                }
                case 86: {
                    this.logger.log(Level.INFO, this.getClass().getName() + ".Version");
                    System.exit(0);
                    break;
                }
                case 117: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startGUI");
                    this.verifierFrameworkContext.setUsingGui(true);
                    break;
                }
                case 114: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-r"});
                        this.usage();
                        break;
                    }
                    boolean validLevel = false;
                    for (int i = 0; i < levels.length; ++i) {
                        if (!arg.equals(levels[i])) continue;
                        validLevel = true;
                        break;
                    }
                    if (!validLevel) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", arg});
                        this.usage();
                        break;
                    }
                    this.setReportingLevel(arg.charAt(0));
                    break;
                }
                case 100: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-d"});
                        this.usage();
                        break;
                    }
                    if (this.verifyAndSetResultDir(arg)) continue block25;
                    this.usage();
                    break;
                }
                case 58: {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqsarg", new Object[]{"verifier", new Character((char)parser.getOptopt()).toString()});
                    this.usage();
                    break;
                }
                case 97: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.app");
                    this.verifierFrameworkContext.setApp(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 65: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.appclient");
                    this.verifierFrameworkContext.setAppClient(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 99: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.connector");
                    this.verifierFrameworkContext.setConnector(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 101: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.ejb");
                    this.verifierFrameworkContext.setEjb(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 119: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.web");
                    this.verifierFrameworkContext.setWeb(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 115: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.webservices");
                    this.verifierFrameworkContext.setWebServices(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 108: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.webservicesclient");
                    this.verifierFrameworkContext.setWebServicesClient(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 80: {
                    this.verifierFrameworkContext.setPersistenceUnits(true);
                    this.verifierFrameworkContext.setPartition(true);
                    break;
                }
                case 63: {
                    char x = (char)parser.getOptopt();
                    if (x == '?') {
                        this.usage();
                    }
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character(x).toString()});
                    this.usage();
                    break;
                }
                case 67: {
                    String arg = parser.getOptarg();
                    if (arg == null || !new File(arg).exists()) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-C"});
                        this.usage();
                    }
                    this.verifierFrameworkContext.setConfigDirStr(arg);
                    break;
                }
                case 112: {
                    this.verifierFrameworkContext.setPortabilityMode(true);
                    break;
                }
                case 109: {
                    String arg = parser.getOptarg();
                    if (arg != null && (arg.equals("1.2") || arg.equals("1.3") || arg.equals("1.4") || arg.equals("5"))) {
                        this.verifierFrameworkContext.setJavaEEVersion(arg);
                    } else {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidjavaeeversion", new Object[]{"verifier", arg});
                        this.usage();
                    }
                    this.logger.log(Level.INFO, this.getClass().getName() + ".specversion", new Object[]{this.verifierFrameworkContext.getJavaEEVersion()});
                    break;
                }
                case 68: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-D"});
                        this.usage();
                    }
                    if (!new File(arg).exists()) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.noDirExists", new Object[]{arg});
                        this.usage();
                    }
                    this.verifierFrameworkContext.setDomainDir(arg);
                    break;
                }
                case 69: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-E"});
                        this.usage();
                    }
                    this.verifierFrameworkContext.setExtDir(arg);
                    break;
                }
                default: {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character((char)c).toString()});
                    this.usage();
                }
            }
        }
        int i = parser.getOptind();
        if (i < argv.length) {
            File jarFile = new File(argv[i]);
            if (!jarFile.exists()) {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidArchive", new Object[]{argv[i]});
                this.usage();
            }
            this.verifierFrameworkContext.setJarFileName(jarFile.getPath());
            this.logger.log(Level.FINE, this.getClass().getName() + ".debug.jarFileName", new Object[]{this.verifierFrameworkContext.getJarFileName()});
            ++i;
            while (i < argv.length) {
                this.logger.log(Level.INFO, this.getClass().getName() + ".extraargs", new Object[]{"verifier", argv[i]});
                ++i;
            }
        } else if (!this.verifierFrameworkContext.isUsingGui()) {
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".jarmissing", new Object[]{"verifier"});
            this.usage();
        }
        if (!isVerboseSet) {
            this.setFormatter();
        }
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.endParseArgs");
    }

    private void processValidLongOpt(int c, String arg, String[] levels) {
        switch (c) {
            case 118: {
                this.logger.setLevel(Level.FINEST);
                Handler[] handler = Logger.getLogger("").getHandlers();
                for (int i = 0; i < handler.length; ++i) {
                    handler[i].setLevel(Level.FINEST);
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.verboseFlag");
                break;
            }
            case 116: {
                this.verifierFrameworkContext.setUseTimeStamp(true);
                break;
            }
            case 104: {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.helpMessage");
                this.usage();
                break;
            }
            case 86: {
                this.logger.log(Level.INFO, this.getClass().getName() + ".Version");
                System.exit(0);
                break;
            }
            case 117: {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startGUI");
                this.verifierFrameworkContext.setUsingGui(true);
                break;
            }
            case 114: {
                if (arg == null) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-r"});
                    this.usage();
                    break;
                }
                boolean validLevel = false;
                for (int i = 0; i < levels.length; ++i) {
                    if (!arg.equals(levels[i])) continue;
                    validLevel = true;
                    break;
                }
                if (!validLevel) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", arg});
                    this.usage();
                    break;
                }
                this.setReportingLevel(arg.charAt(0));
                break;
            }
            case 100: {
                if (arg == null) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-d"});
                    this.usage();
                    break;
                }
                if (this.verifyAndSetResultDir(arg)) break;
                this.usage();
                break;
            }
            default: {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character((char)c).toString()});
                this.usage();
            }
        }
    }

    private void setReportingLevel(char c) {
        boolean setWarningLevelOnce = false;
        switch (c) {
            case 'w': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayWarningFailures");
                    this.verifierFrameworkContext.setReportLevel(1);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.verifierFrameworkContext.getReportLevel())});
                break;
            }
            case 'f': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayFailures");
                    this.verifierFrameworkContext.setReportLevel(0);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.verifierFrameworkContext.getReportLevel())});
                break;
            }
            case 'a': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayAll");
                    this.verifierFrameworkContext.setReportLevel(2);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.verifierFrameworkContext.getReportLevel())});
                break;
            }
            default: {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", new Character(c).toString()});
                this.usage();
            }
        }
    }

    private void usage() {
        if (!this.verifierFrameworkContext.isUsingGui()) {
            this.logger.log(Level.INFO, this.getUsageString());
            System.exit(1);
        }
    }

    private String getUsageString() {
        String usage = "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine1", "usage: VERIFIER [optional_params] <jarFile>") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine2", "where :  [optional_params]: Must be:") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine5", "    -d|--destdir <destination dir> : Verifier results are put in the specified existing directory") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine35", "   -D|--domain      : Absolute path of the domain directory. Domain directory will be ignored if verifier is run with -p option. The default domain directory is <AS_INSTALL_DIR>/domains/domain1") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine36", "   -p|--portability : Verifier will be run in portability mode with this option. Verifier runs in appserver mode by default. In the default mode verifier additionally checks correct usage of Sun application server features.") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine16", "   -h|--help|-?     : display verifier help") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine34", "   -t|--timestamp   : verifer results are generated with timestamp appended to it") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine7", "    -u|--gui      : use Verifier GUI") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine4", "     -v|--verbose : Display more execution information ") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine17", "   -V|--version   : display verifier tool version") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine8", "          (Note: Overrides default behavior,required jarFile not needed) ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine10", "   -r|--reportlevel : result reporting level") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine11", "   level=   a|all : set output report level to display all results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine14", "            f|failures : set output report level to display only failure results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine12", "            w|warnings : set output report level to display only warning and failure results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine27", "   -a|--app         : run only the Application tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine28", "   -A|--appclient   : run only the Application Client tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine29", "   -c|--connector   : run only the Connector tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine30", "   -e|--ejb         : run only the EJB tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine31", "   -w|--web         : run only the Web tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine32", "   -s|--webservices : run only the WebServices tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine33", "   -l|--webservicesclient : run only the WebServicesClient tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine37", "   -P|--persistence : run only the EJB 3.0 persistence tests") + "\n\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine19", "Note: The default mode is non-verbose mode and the default reportlevel is to display only warning and failure results.\n") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine20", "<jarFile>: ear/war/jar/rar file to perform static verification on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine21", "Below is an example which runs verifier in verbose mode and writes all the results of static verification of file sample.ear to the destination directory /verifierresults") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine24", " verifier -v -ra -d /verifierresults sample.ear") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine25", " The results get generated in both text and xml format.") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine26", " Two result files, sample.ear.txt and sample.ear.xml, will be created.") + "\n\n";
        return usage;
    }

    private boolean verifyAndSetResultDir(String name) {
        File outputDir = new File(name);
        if (outputDir.exists()) {
            if (outputDir.isDirectory()) {
                if (outputDir.canWrite()) {
                    this.verifierFrameworkContext.setOutputDirName(name);
                    return true;
                }
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.noPermissions", new Object[]{name});
                return false;
            }
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.notADir", new Object[]{name});
            return false;
        }
        this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.noDirExists", new Object[]{name});
        return false;
    }

    private void setFormatter() {
        Handler[] handlers = this.logger.getParent().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof ConsoleHandler)) continue;
            handlers[i].setFormatter(new VerifierFormatter());
        }
    }

    private String getReportLevelString(int rl) {
        String rls = "";
        if (rl == 0) {
            rls = this._FOStr;
        } else if (rl == 1) {
            rls = this._WFOStr;
        } else if (rl == 2) {
            rls = this._AOStr;
        }
        return rls;
    }
}

